/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.store.heaplimit;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntUnaryOperator;
import kd.bos.algo.Row;
import kd.bos.algo.dataset.store.heaplimit.HeapLimitPolicy;

public class MaxRowsLimitPolicy
implements HeapLimitPolicy {
    private AtomicInteger count = new AtomicInteger(0);
    private AtomicInteger limit;

    public MaxRowsLimitPolicy(int limit) {
        this.limit = new AtomicInteger(limit);
    }

    @Override
    public boolean canAddRow(Row row) {
        if (this.count.get() < this.limit.get()) {
            this.count.incrementAndGet();
            return true;
        }
        return false;
    }

    @Override
    public void releaseRowCount(final int rowCount) {
        this.count.updateAndGet(new IntUnaryOperator(){

            @Override
            public int applyAsInt(int operand) {
                return operand - rowCount;
            }
        });
    }

    public void setMaxRowsLimit(int limit) {
        this.limit.set(limit);
    }
}

