/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.store.mm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.dataset.store.MultiValueMapStore;
import kd.bos.algo.dataset.store.mm.MMFactory;
import kd.bos.algo.dataset.store.mm.MMMapLimit;
import kd.bos.algo.dataset.store.mm.MemoryAllocateException;
import kd.bos.algo.dataset.store.mm.QuoteListener;
import kd.bos.algo.env.ThreadContext;

public class MMMultiValueMapStore<K, V>
implements MultiValueMapStore<K, V> {
    private HashMap<K, List<V>> map = new HashMap();
    private final int oneQuoteRows;
    private final QuoteListener listener;
    private int size;
    private int quote;
    private boolean closed;

    public MMMultiValueMapStore(int fieldCount, QuoteListener listener) {
        this.oneQuoteRows = MMFactory.getQuoteCalculator().calcOneQuoteRows(fieldCount);
        this.listener = listener;
        ThreadContext.getCurrent().addCloseable(this);
    }

    @Override
    public void put(K key, V value) {
        List<V> list = this.map.get(key);
        if (list == null) {
            list = new ArrayList<V>();
            this.map.put(key, list);
        }
        list.add(value);
        ++this.size;
        if (this.size % this.oneQuoteRows == 0) {
            ++this.quote;
            MMMapLimit.incr();
            try {
                this.listener.quoteInc(1);
            }
            catch (MemoryAllocateException memoryAllocateException) {
                // empty catch block
            }
        }
    }

    @Override
    public List<V> get(K key) {
        return this.map.get(key);
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            if (this.quote > 0) {
                this.listener.quoteDec(this.quote);
                MMMapLimit.decr(this.quote);
                this.quote = 0;
            }
            ThreadContext.getCurrent().removeCloseable(this);
        }
    }

    @Override
    public Iterator<K> keyIterator() {
        return this.map.keySet().iterator();
    }
}

