/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.store.mm;

import java.util.Iterator;
import kd.bos.algo.AlgoException;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.config.AlgoConfiguration;
import kd.bos.algo.dataset.AutoCloseIterator;
import kd.bos.algo.dataset.OrderItem;
import kd.bos.algo.dataset.store.AbstractStore;
import kd.bos.algo.dataset.store.mm.MMFactory;
import kd.bos.algo.dataset.store.mm.MemoryBufferStore;
import kd.bos.algo.dataset.store.sort.RowOrderComparator;
import kd.bos.algo.dataset.store.sort.TashaSortMerger;
import kd.bos.algo.env.ThreadContext;

public class MMOrderStore
extends AbstractStore {
    private static final long serialVersionUID = 5437528116901485019L;
    private final OrderItem[] orderItems;
    private MemoryBufferStore heapStore;
    private TashaSortMerger merger;
    private boolean closed;
    private boolean hasMergeEof;
    private final int heapMaxRows;
    private int heapSize;

    public MMOrderStore(RowMeta rowMeta, OrderItem[] orderItems) {
        super(rowMeta);
        this.orderItems = orderItems;
        ThreadContext.getCurrent().addStore(this);
        this.heapMaxRows = AlgoConfiguration.SORTMERGE_BUFFER_SIZE.getInt();
        this.heapStore = MMFactory.createMemeryBufferStore(rowMeta, new RowOrderComparator(rowMeta, orderItems));
        this.refer(this);
    }

    @Override
    public Iterator<Row> getRowIterator0() {
        if (this.merger == null) {
            return this.heapStore.getRowIterator();
        }
        try {
            this.ensureMergeEof();
            AutoCloseIterator iter = this.merger.getIterator();
            iter = new AutoCloseIterator(this, iter);
            return iter;
        }
        catch (InterruptedException e) {
            throw new AlgoException(e);
        }
    }

    @Override
    public void write(Iterator<Row> iter) {
        if (this.merger != null) {
            this.merger.writeInput(iter);
            return;
        }
        while (this.heapSize < this.heapMaxRows && iter.hasNext()) {
            this.heapStore.write(iter.next());
            ++this.heapSize;
        }
        if (iter.hasNext()) {
            this.writeX(this.rowMeta, this.heapStore.getRowIterator());
            this.heapStore.close();
            this.writeX(this.rowMeta, iter);
        }
    }

    @Override
    public void write(Row row) {
        throw new UnsupportedOperationException();
    }

    private void writeX(RowMeta rowMeta, Iterator<Row> iter) {
        try {
            if (this.merger == null) {
                this.merger = new TashaSortMerger(rowMeta, this.orderItems, AlgoConfiguration.SORTMERGE_BUFFER_NUMBER.getInt(), AlgoConfiguration.SORTMERGE_BUFFER_SIZE.getInt());
            }
            this.merger.writeInput(iter);
        }
        catch (Exception e) {
            throw new AlgoException(e);
        }
    }

    @Override
    public void realClose() {
        if (!this.closed) {
            ThreadContext.getCurrent().removeStore(this);
            this.closed = true;
            if (this.heapStore != null) {
                this.heapStore.close();
            }
            if (this.merger != null) {
                this.merger.close();
            }
        }
    }

    @Override
    public boolean isCopyable() {
        return this.merger == null;
    }

    @Override
    public RowMeta getRowMeta() {
        return this.rowMeta;
    }

    @Override
    public int size() {
        this.checkClosed();
        if (this.merger == null) {
            return this.heapSize;
        }
        this.ensureMergeEof();
        return this.merger.getRowCount();
    }

    @Override
    public boolean isStandalone() {
        return false;
    }

    private void ensureMergeEof() {
        if (!this.hasMergeEof) {
            this.merger.writeEof();
            this.hasMergeEof = true;
        }
    }
}

