/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.store.mm;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.store.AbstractStore;
import kd.bos.algo.dataset.store.SortableStore;
import kd.bos.algo.dataset.store.mm.StoreUnitAllocator;
import kd.bos.algo.dataset.store.mm.StoreUnitHolder;

public final class MemoryBufferStore
extends AbstractStore
implements SortableStore {
    private final Comparator<Row> sortComparator;
    private final StoreUnitAllocator storeUnitAllocator;
    private int size = 0;
    StoreUnitHolder holder;
    private boolean sorted;
    private ArrayList<Row> sortedList;

    public MemoryBufferStore(StoreUnitAllocator storeUnitAllocator, RowMeta rowMeta, Comparator<Row> sortComparator) {
        super(rowMeta);
        this.storeUnitAllocator = storeUnitAllocator;
        this.sortComparator = sortComparator;
        this.holder = storeUnitAllocator.allocateMemoryOnly(rowMeta);
    }

    @Override
    public Iterator<Row> getRowIterator0() {
        if (this.sortComparator != null && !this.sorted) {
            this.doSort();
        }
        if (this.holder.isMemory()) {
            return this.holder.iterator();
        }
        return this.sortedList.iterator();
    }

    @Override
    public void doSort() {
        if (this.holder.isMemory()) {
            this.holder.doSort(this.sortComparator);
        } else {
            this.sortedList = new ArrayList();
            Iterator<Row> iter = this.holder.iterator();
            while (iter.hasNext()) {
                this.sortedList.add(iter.next());
            }
            this.sortedList.sort(this.sortComparator);
        }
        this.sorted = true;
    }

    @Override
    public final void write(Iterator<Row> iter) {
        while (iter.hasNext()) {
            this.write(iter.next());
        }
    }

    @Override
    public final void write(Row row) {
        if (this.holder.addRow(row)) {
            ++this.size;
        } else {
            StoreUnitHolder spillHolder = this.storeUnitAllocator.allocateSpillOnly(this.rowMeta);
            Iterator<Row> iter = this.holder.iterator();
            while (iter.hasNext()) {
                spillHolder.addRow(iter.next());
            }
            this.holder.close();
            this.holder = spillHolder;
            this.holder.addRow(row);
            ++this.size;
        }
    }

    @Override
    public void realClose() {
        this.holder.close();
        this.holder = null;
        this.sortedList = null;
    }

    @Override
    public RowMeta getRowMeta() {
        return this.rowMeta;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isStandalone() {
        return false;
    }

    @Override
    public boolean isCopyable() {
        return true;
    }
}

