/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.store.mm;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import kd.bos.algo.config.AlgoConfiguration;
import kd.bos.algo.dataset.store.mm.Spiller;
import kd.bos.algo.dataset.store.mm.StoreUnitHolder;
import kd.bos.algo.util.concurrent.AlgoExecutors;

class SpillerAsync
extends Spiller {
    private volatile boolean started = false;
    private ExecutorService es;
    private LinkedBlockingQueue<StoreUnitHolder> queue;

    SpillerAsync(int queueSize) {
        this.queue = new LinkedBlockingQueue(queueSize);
    }

    @Override
    public boolean write(StoreUnitHolder holder) {
        if (!this.started) {
            this.start();
        }
        return this.queue.offer(holder);
    }

    private synchronized void start() {
        if (!this.started) {
            this.started = true;
            int size = AlgoConfiguration.MM_SPILL_ASYNC_THREADPOOL_SIZE.getInt();
            this.es = AlgoExecutors.newFixedThreadPool(size, "memory-spill");
            for (int i = 0; i < size; ++i) {
                this.es.submit(new SpillRunnalbe());
            }
        }
    }

    private class SpillRunnalbe
    implements Runnable {
        private SpillRunnalbe() {
        }

        @Override
        public void run() {
            while (true) {
                StoreUnitHolder holder;
                try {
                    holder = (StoreUnitHolder)SpillerAsync.this.queue.take();
                }
                catch (InterruptedException e) {
                    continue;
                }
                holder.transfer();
            }
        }
    }
}

