/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.store.mm;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import kd.bos.algo.AlgoException;
import kd.bos.algo.Row;
import kd.bos.algo.dataset.store.mm.MemUnit;
import kd.bos.algo.dataset.store.mm.SpillUnit;
import kd.bos.algo.dataset.store.mm.StoreUnit;

public class StoreUnitHolder
implements Iterable<Row> {
    private StoreUnit unit;
    private AlgoException error;
    private ArrayList<Listener> listeners = new ArrayList(2);
    private boolean closed;
    private boolean addFinished = false;

    public StoreUnitHolder(StoreUnit unit) {
        this.unit = unit;
    }

    public synchronized boolean isMemory() {
        return this.unit instanceof MemUnit;
    }

    public synchronized boolean addRow(Row row) {
        this.checkErrorAndClosed();
        return this.unit.addRow(row);
    }

    @Override
    public synchronized Iterator<Row> iterator() {
        this.checkErrorAndClosed();
        return this.unit.iterator();
    }

    public synchronized int size() {
        return this.unit.size();
    }

    public synchronized void close() {
        if (!this.closed) {
            this.closed = true;
            this.doClose(this.unit);
        }
    }

    private void doClose(StoreUnit unit) {
        unit.release();
        if (unit.isMemory()) {
            for (Listener listener : this.listeners) {
                listener.released();
            }
        }
    }

    public void finishAdd() {
        this.addFinished = true;
    }

    public boolean isAddFinished() {
        return this.addFinished;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transfer() {
        StoreUnit old = this.unit;
        try {
            StoreUnitHolder storeUnitHolder = this;
            synchronized (storeUnitHolder) {
                if (!this.unit.isMemory()) {
                    return;
                }
                if (this.closed) {
                    return;
                }
                this.unit = this.doSpill(this.unit);
            }
            old.release();
            for (Listener listener : this.listeners) {
                listener.released();
            }
        }
        catch (AlgoException e) {
            this.error = e;
        }
        catch (Exception e) {
            this.error = new AlgoException(e);
        }
    }

    private void checkErrorAndClosed() {
        if (this.error != null) {
            throw this.error;
        }
        if (this.closed) {
            throw new AlgoException("Store has been closed.");
        }
    }

    private StoreUnit doSpill(StoreUnit unit) {
        if (!unit.isMemory()) {
            return unit;
        }
        SpillUnit spillUnit = new SpillUnit(unit.rowMeta);
        Iterator<Row> iter = unit.iterator();
        while (iter.hasNext()) {
            spillUnit.addRow(iter.next());
        }
        return spillUnit;
    }

    public synchronized void doSort(Comparator<Row> comparator) {
        this.checkErrorAndClosed();
        if (this.unit instanceof MemUnit) {
            ((MemUnit)this.unit).doSort(comparator);
        }
    }

    public synchronized int getQuote() {
        return this.unit.getQuote();
    }

    public static interface Listener {
        public void released();
    }
}

