/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.store.sort;

import com.google.common.collect.MinMaxPriorityQueue;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.AlgoException;

public final class FixedPriorityQueue<T> {
    private final MinMaxPriorityQueue<T> queue;
    private final Comparator<T> comparator;
    private List<T> orderedData;
    private final int top;
    private T max;

    public FixedPriorityQueue(int top, Comparator<T> comparator) {
        this.top = top;
        this.comparator = comparator;
        this.queue = MinMaxPriorityQueue.orderedBy(comparator).maximumSize(top).create();
    }

    public void add(T element) {
        if (this.orderedData != null) {
            throw new AlgoException("FixedPriorityQueue has return iterator,can not add element.");
        }
        if (this.max == null) {
            this.queue.add(element);
            if (this.queue.size() == this.top) {
                this.max = this.queue.peekLast();
            }
        } else if (this.comparator.compare(element, this.max) < 0) {
            this.queue.offer(element);
            this.max = this.queue.peekLast();
        }
    }

    public Iterator<T> iterator() {
        if (this.orderedData == null) {
            this.orderedData = new ArrayList<T>(this.top);
            while (!this.queue.isEmpty()) {
                this.orderedData.add(this.queue.poll());
            }
        }
        return this.orderedData.iterator();
    }
}

