/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.store.sort;

import java.util.Comparator;
import java.util.Iterator;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.algo.dataset.store.SortableStore;
import kd.bos.algo.dataset.store.StoreFactory;

public class TashaSortBuffer
implements Iterable<Row> {
    private SortableStore store;
    private boolean sorted;
    private int maxSize;
    private RowMeta rowMeta;
    private Comparator<Row> comparator;

    public TashaSortBuffer(RowMeta rowMeta, Comparator<Row> comparator, int maxSize) {
        this.rowMeta = rowMeta;
        this.comparator = comparator;
        this.maxSize = maxSize;
        this.createStore();
    }

    private void createStore() {
        this.store = StoreFactory.createSortBufferStore(this.rowMeta, this.comparator);
    }

    public boolean addRow(Row row) {
        if (this.store.size() < this.maxSize) {
            this.store.write(((AbstractRow)row).persist());
            return true;
        }
        return false;
    }

    @Override
    public Iterator<Row> iterator() {
        if (!this.sorted) {
            this.doSort();
            this.sorted = true;
        }
        return this.store.getRowIterator();
    }

    public void doSort() {
        this.store.doSort();
        this.sorted = true;
    }

    public int getRowCount() {
        return this.store.size();
    }

    public void reset() {
        this.store.close();
        this.createStore();
        this.sorted = false;
    }

    public void close() {
        if (this.store != null) {
            this.store.close();
        }
    }
}

