/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.store.spill;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.algo.AlgoException;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.config.AlgoConfiguration;
import kd.bos.algo.dataset.store.spill.HeapMemoryManager;
import kd.bos.algo.dataset.store.spill.LazyMemorySegmentSource;
import kd.bos.algo.dataset.store.spill.MemIO;
import kd.bos.algo.dataset.store.spill.MemIOFactory;
import kd.bos.algo.dataset.store.spill.RowSerializer;
import kd.bos.algo.dataset.store.spill.SpillWriter;
import kd.bos.algo.dataset.store.spill.SpillingOutputView;
import kd.bos.algo.exception.AlgoExceedAllowMaxRowsToDiskException;
import kd.bos.algo.util.io.disk.ChannelReaderInputView;
import kd.bos.algo.util.io.disk.IOManager;
import kd.bos.algo.util.memory.DataInputView;
import org.apache.log4j.Logger;

public class AsynSpillWriter
implements SpillWriter {
    private static AtomicInteger instanceCount = new AtomicInteger();
    protected final RowSerializer serializer;
    private int elementCount;
    protected final SpillingOutputView buffer;
    private final RowMeta rowMeta;
    protected final HeapMemoryManager memoryManager;
    private final LazyMemorySegmentSource memSource;
    private boolean closed;
    private static Logger logger = Logger.getLogger(AsynSpillWriter.class);
    private LinkedList<InputViewIterator> iterators = new LinkedList();
    private boolean eof = false;

    public AsynSpillWriter(RowMeta rowMeta, HeapMemoryManager memoryManager, IOManager ioManager, int numPages) {
        this.rowMeta = rowMeta;
        this.memoryManager = memoryManager;
        this.memSource = new LazyMemorySegmentSource(null, memoryManager, numPages);
        try {
            this.buffer = new SpillingOutputView(ioManager, this.memSource, memoryManager.getPageSize());
            this.serializer = new RowSerializer(rowMeta);
            instanceCount.incrementAndGet();
        }
        catch (Exception e) {
            try {
                this.memSource.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AlgoException(e);
        }
    }

    public static int getInstanceCount() {
        return instanceCount.get();
    }

    @Override
    public void writeRowIter(Iterator<Row> iter) {
        if (this.eof) {
            throw new AlgoException("Can't write again after iterated.");
        }
        try {
            while (iter.hasNext()) {
                this.serializer.serialize(iter.next(), this.buffer);
                ++this.elementCount;
                this.checkLimit();
            }
        }
        catch (Exception e) {
            try {
                this.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw AlgoException.wrap(e);
        }
    }

    @Override
    public void writeRow(Row row) {
        if (this.eof) {
            throw new AlgoException("Can't write again after iterated.");
        }
        try {
            this.serializer.serialize(row, this.buffer);
            ++this.elementCount;
            this.checkLimit();
        }
        catch (Exception e) {
            try {
                this.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw AlgoException.wrap(e);
        }
    }

    private void checkLimit() {
        int maxrows = AlgoConfiguration.DATASET_SPILL_MAXROWS.getInt();
        if (this.elementCount >= maxrows) {
            String message = "Exceed spilling disk rows limitation:" + this.elementCount + ", current rows count:" + this.elementCount + ", DataSet:" + this.rowMeta.toString();
            logger.error((Object)message);
            throw new AlgoExceedAllowMaxRowsToDiskException(message, this.elementCount, maxrows);
        }
    }

    @Override
    public void writeEof() {
        this.eof = true;
    }

    private LazyMemorySegmentSource getMemSourceForInputView() {
        MemIO memIO = MemIOFactory.createForSpillBuffer();
        return new LazyMemorySegmentSource(null, memIO.getMemoryManager(), memIO.getMemoryManager().getTotalNumPages());
    }

    @Override
    public Iterator<Row> iterator() {
        DataInputView inView;
        InputViewIterator iter2;
        if (!this.eof) {
            this.eof = true;
        }
        boolean allClosed = true;
        for (InputViewIterator iter2 : this.iterators) {
            if (iter2.isClosed()) continue;
            allClosed = false;
            break;
        }
        try {
            inView = allClosed ? this.buffer.getView() : this.buffer.getViewNew(this.getMemSourceForInputView());
        }
        catch (Exception e) {
            try {
                this.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new AlgoException(e);
        }
        iter2 = new InputViewIterator(inView);
        this.iterators.add(iter2);
        return iter2;
    }

    @Override
    public int size() {
        return this.elementCount;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        instanceCount.decrementAndGet();
        this.memSource.close();
        for (InputViewIterator iter : this.iterators) {
            try {
                iter.closeInView();
            }
            catch (Exception exception) {}
        }
        try {
            this.buffer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class InputViewIterator
    implements Iterator<Row> {
        private boolean inViewClosed;
        private int pos;
        private DataInputView inView;

        public InputViewIterator(DataInputView inView) {
            this.inView = inView;
        }

        @Override
        public boolean hasNext() {
            boolean b;
            boolean bl = b = this.pos < AsynSpillWriter.this.elementCount;
            if (!b) {
                this.closeInView();
            }
            return b;
        }

        @Override
        public Row next() {
            if (this.pos >= AsynSpillWriter.this.elementCount) {
                this.closeInView();
                throw new NoSuchElementException();
            }
            try {
                Row row = AsynSpillWriter.this.serializer.deserialize(this.inView);
                ++this.pos;
                return row;
            }
            catch (Exception e) {
                try {
                    this.closeInView();
                    AsynSpillWriter.this.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw new AlgoException(e, "pos=" + this.pos + ",elementCount=" + AsynSpillWriter.this.elementCount, new Object[0]);
            }
        }

        public boolean isClosed() {
            return this.inViewClosed;
        }

        private void closeInView() {
            if (this.inViewClosed) {
                return;
            }
            this.inViewClosed = true;
            if (this.inView instanceof ChannelReaderInputView) {
                try {
                    ((ChannelReaderInputView)this.inView).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

