/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.store.spill;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.util.memory.MemorySegment;

public class HeapMemoryManager {
    private final int memorySize;
    private final int pageSize;
    private final int totalNumPages;

    public HeapMemoryManager(int memorySize, int pageSize) {
        this.memorySize = memorySize;
        this.pageSize = pageSize;
        this.totalNumPages = memorySize / pageSize;
        if (this.totalNumPages < 1) {
            throw new IllegalArgumentException("The given amount of memory amounted to less than one page.");
        }
    }

    public int getMemorySize() {
        return this.memorySize;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getTotalNumPages() {
        return this.totalNumPages;
    }

    public void shutdown() {
    }

    public MemorySegment allocateOne() {
        return new MemorySegment(new byte[this.pageSize], null);
    }

    public void allocatePages(Object owner, ArrayList<MemorySegment> list, int maxNum) {
        for (int i = maxNum; i > 0; --i) {
            MemorySegment segment = new MemorySegment(new byte[this.pageSize], null);
            list.add(segment);
        }
    }

    public void release(ArrayList<MemorySegment> allocatedMemorySegments) {
    }

    public List<MemorySegment> allocatePages(Object owner, int totalNumPages) {
        ArrayList<MemorySegment> list = new ArrayList<MemorySegment>();
        for (int i = totalNumPages; i > 0; --i) {
            MemorySegment segment = new MemorySegment(new byte[this.pageSize], null);
            list.add(segment);
        }
        return list;
    }
}

