/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.store.spill;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.dataset.store.spill.HeapMemoryManager;
import kd.bos.algo.util.memory.MemorySegment;
import kd.bos.algo.util.memory.MemorySegmentSource;

public class LazyMemorySegmentSource
implements MemorySegmentSource {
    private HeapMemoryManager mm;
    private int maxNum;
    private int allocatedNum;
    private Object owner;

    public LazyMemorySegmentSource(Object owner, HeapMemoryManager mm, int maxNum) {
        this.owner = owner;
        this.mm = mm;
        this.maxNum = maxNum;
    }

    public List<MemorySegment> getAllSegment() {
        ArrayList<MemorySegment> list = new ArrayList<MemorySegment>();
        this.mm.allocatePages(this.owner, list, this.maxNum);
        this.allocatedNum = this.maxNum;
        return list;
    }

    @Override
    public MemorySegment nextSegment() {
        if (this.allocatedNum < this.maxNum) {
            ++this.allocatedNum;
            return this.mm.allocateOne();
        }
        return null;
    }

    public void close() {
    }
}

