/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.store.spill;

import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.CacheHint;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.cache.CachedDataSetImpl;
import kd.bos.algo.dataset.cache.DataSetCacheMeta;
import kd.bos.algo.dataset.cache.fs.FSSpiImpl;
import kd.bos.algo.dataset.store.spill.SpillWriter;
import kd.bos.algo.storage.local.LocalStorage;

public class LocalStorageSpillWriter
implements SpillWriter {
    private FSSpiImpl cacheSpi;
    DataSetCacheMeta meta;
    private boolean finished;

    public LocalStorageSpillWriter(RowMeta rowMeta) {
        LocalStorage storage = new LocalStorage();
        this.cacheSpi = new FSSpiImpl(storage);
        CacheHint hint = CacheHint.getDefault();
        hint.setStorageType("local");
        hint.setPageSize(20000);
        hint.setTimeout(120L, TimeUnit.MINUTES);
        this.cacheSpi.open(rowMeta, hint);
    }

    @Override
    public void writeRowIter(Iterator<Row> iter) {
        this.cacheSpi.append(iter);
    }

    @Override
    public void writeRow(Row row) {
        this.cacheSpi.append(row);
    }

    @Override
    public void writeEof() {
    }

    @Override
    public Iterator<Row> iterator() {
        if (!this.finished) {
            this.meta = this.cacheSpi.finish();
        }
        CachedDataSetImpl cds = new CachedDataSetImpl(this.cacheSpi, this.meta);
        return cds.iterator(0, this.meta.getRowCount());
    }

    @Override
    public int size() {
        return this.meta.getRowCount();
    }

    @Override
    public void close() {
        this.cacheSpi.delete(this.meta);
    }
}

