/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.store.spill;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;
import kd.bos.algo.AlgoException;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.config.AlgoConfiguration;
import kd.bos.algo.dataset.store.spill.SpillWriter;
import kd.bos.algo.serde.RowSerde;
import org.apache.commons.io.FilenameUtils;

public class SimpleSpillWriter
implements SpillWriter {
    private final RowMeta rowMeta;
    private RowSerde rowSerde;
    private final int bufferSize;
    private File file;
    private DataOutputStream outputStream;
    private int size;
    private boolean writeFinished = false;
    private static int index = 0;
    private static String[] tempDirs = AlgoConfiguration.IO_TMP_DIRS.getString().split(",");
    private ArrayList<MyIterator> iterators = new ArrayList(1);

    private static String getDirectory() {
        return tempDirs[index++ % tempDirs.length] + File.separator + "fastspill";
    }

    SimpleSpillWriter(RowMeta rowMeta, int bufferSize) {
        this.rowMeta = rowMeta;
        this.rowSerde = RowSerde.Factory.get(rowMeta);
        this.bufferSize = bufferSize;
        try {
            this.initFile();
        }
        catch (IOException e) {
            throw new AlgoException(e);
        }
    }

    private void initFile() throws IOException {
        String dir = FilenameUtils.normalize((String)SimpleSpillWriter.getDirectory());
        File directory = new File(dir);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        do {
            this.file = new File(dir + "/" + UUID.randomUUID().toString());
        } while (this.file.exists() || !this.file.createNewFile());
        this.file.deleteOnExit();
        FileOutputStream fout = new FileOutputStream(this.file);
        if (this.bufferSize > 0) {
            BufferedOutputStream bos = new BufferedOutputStream(fout, this.bufferSize);
            this.outputStream = new DataOutputStream(bos);
        } else {
            this.outputStream = new DataOutputStream(fout);
        }
    }

    @Override
    public void writeRowIter(Iterator<Row> iter) {
        while (iter.hasNext()) {
            this.writeRow(iter.next());
        }
    }

    @Override
    public void writeRow(Row row) {
        ++this.size;
        this.rowSerde.write(this.rowMeta, row, this.outputStream);
    }

    @Override
    public void writeEof() {
        if (!this.writeFinished) {
            try {
                this.outputStream.close();
            }
            catch (IOException e) {
                throw new AlgoException(e);
            }
            this.outputStream = null;
        }
    }

    @Override
    public Iterator<Row> iterator() {
        this.writeEof();
        MyIterator iterator = new MyIterator();
        this.iterators.add(iterator);
        return iterator;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void close() {
        for (MyIterator iter : this.iterators) {
            iter.close();
        }
        this.iterators.clear();
        if (this.file != null) {
            this.file.delete();
        }
    }

    class MyIterator
    implements Iterator<Row> {
        private DataInputStream inputStream = null;
        private FileInputStream fin;
        private int index = 0;
        private boolean closed;

        public MyIterator() {
            try {
                this.fin = new FileInputStream(SimpleSpillWriter.this.file);
                if (SimpleSpillWriter.this.bufferSize > 0) {
                    BufferedInputStream bin = new BufferedInputStream(this.fin, SimpleSpillWriter.this.bufferSize);
                    this.inputStream = new DataInputStream(bin);
                } else {
                    this.inputStream = new DataInputStream(this.fin);
                }
            }
            catch (IOException e) {
                throw new AlgoException(e);
            }
        }

        @Override
        public boolean hasNext() {
            boolean hasNext;
            boolean bl = hasNext = this.index < SimpleSpillWriter.this.size;
            if (!hasNext) {
                this.close();
            }
            return hasNext;
        }

        @Override
        public Row next() {
            ++this.index;
            return SimpleSpillWriter.this.rowSerde.read(SimpleSpillWriter.this.rowMeta, this.inputStream);
        }

        void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            SimpleSpillWriter.this.iterators.remove(this);
            if (this.fin != null) {
                try {
                    this.fin.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.inputStream != null) {
                try {
                    this.inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

