/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.store.spill;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.dataset.store.spill.LazyMemorySegmentSource;
import kd.bos.algo.util.ObjectRef;
import kd.bos.algo.util.io.disk.BlockChannelReader;
import kd.bos.algo.util.io.disk.BlockChannelWriter;
import kd.bos.algo.util.io.disk.HeaderlessChannelReaderInputView;
import kd.bos.algo.util.io.disk.IOManager;
import kd.bos.algo.util.io.disk.RandomAccessInputView;
import kd.bos.algo.util.memory.AbstractPagedOutputView;
import kd.bos.algo.util.memory.DataInputView;
import kd.bos.algo.util.memory.MemorySegment;
import kd.bos.algo.util.memory.MemorySegmentSource;

public class SpillingOutputView
extends AbstractPagedOutputView {
    private ArrayList<MemorySegment> fullSegments;
    private final MemorySegmentSource memorySource;
    private BlockChannelWriter<MemorySegment> writer;
    private final IOManager ioManager;
    private int blockCount;
    private int numBytesInLastSegment;
    private int numMemorySegmentsInWriter;
    private ObjectRef<Exception> closedRef = new ObjectRef();

    public SpillingOutputView(IOManager ioManager, MemorySegmentSource memSource, int segmentSize) {
        super(memSource.nextSegment(), segmentSize, 0);
        this.fullSegments = new ArrayList(2);
        this.memorySource = memSource;
        this.ioManager = ioManager;
    }

    @Override
    protected MemorySegment nextSegment(MemorySegment current, int positionInCurrent) throws IOException {
        if (this.writer == null) {
            this.fullSegments.add(current);
            MemorySegment nextSeg = this.memorySource.nextSegment();
            if (nextSeg != null) {
                return nextSeg;
            }
            this.writer = this.ioManager.createBlockChannelWriter(this.ioManager.createChannel());
            this.numMemorySegmentsInWriter = this.blockCount = this.fullSegments.size();
            for (MemorySegment segment : this.fullSegments) {
                this.writer.writeBlock(segment);
            }
            this.fullSegments.clear();
            MemorySegment seg = this.writer.getNextReturnedBlock();
            --this.numMemorySegmentsInWriter;
            return seg;
        }
        this.writer.writeBlock(current);
        ++this.blockCount;
        return this.writer.getNextReturnedBlock();
    }

    public DataInputView getViewNew(LazyMemorySegmentSource lazyMemorySegmentSource) throws IOException {
        if (this.writer == null) {
            return new RandomAccessInputView(this.fullSegments, this.segmentSize, this.numBytesInLastSegment, this.closedRef);
        }
        this.clear();
        BlockChannelReader<MemorySegment> reader = this.ioManager.createBlockChannelReader(this.writer.getChannelID());
        HeaderlessChannelReaderInputView externalInView = new HeaderlessChannelReaderInputView(reader, lazyMemorySegmentSource.getAllSegment(), this.blockCount, this.numBytesInLastSegment, false, 0L, this.closedRef);
        return externalInView;
    }

    public DataInputView getView() throws IOException {
        if (this.getCurrentSegment() != null) {
            if (this.writer == null) {
                this.fullSegments.add(this.getCurrentSegment());
                this.numBytesInLastSegment = this.getCurrentPositionInSegment();
            } else {
                this.writer.writeBlock(this.getCurrentSegment());
                ++this.numMemorySegmentsInWriter;
                this.numBytesInLastSegment = this.getCurrentPositionInSegment();
                ++this.blockCount;
                this.writer.close();
                for (int i = this.numMemorySegmentsInWriter; i > 0; --i) {
                    this.fullSegments.add(this.writer.getNextReturnedBlock());
                }
                this.numMemorySegmentsInWriter = 0;
            }
        }
        this.clear();
        if (this.writer == null) {
            return new RandomAccessInputView(this.fullSegments, this.segmentSize, this.numBytesInLastSegment, this.closedRef);
        }
        BlockChannelReader<MemorySegment> reader = this.ioManager.createBlockChannelReader(this.writer.getChannelID());
        HeaderlessChannelReaderInputView externalInView = new HeaderlessChannelReaderInputView(reader, this.fullSegments, this.blockCount, this.numBytesInLastSegment, false, 0L, this.closedRef);
        return externalInView;
    }

    public List<MemorySegment> close() throws IOException {
        this.closedRef.set(new Exception());
        ArrayList<MemorySegment> segments = new ArrayList<MemorySegment>(this.fullSegments.size() + this.numMemorySegmentsInWriter);
        if (this.getCurrentSegment() != null) {
            segments.add(this.getCurrentSegment());
            this.clear();
        }
        SpillingOutputView.moveAll(this.fullSegments, segments);
        this.fullSegments = null;
        if (this.writer != null) {
            this.writer.close();
            for (int i = this.numMemorySegmentsInWriter; i > 0; --i) {
                segments.add(this.writer.getNextReturnedBlock());
            }
            this.writer.closeAndDelete();
            this.writer = null;
        }
        return segments;
    }

    private static final <E> void moveAll(ArrayList<E> source, ArrayList<E> target) {
        target.ensureCapacity(target.size() + source.size());
        for (int i = source.size() - 1; i >= 0; --i) {
            target.add(source.remove(i));
        }
    }
}

