/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.union;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.dataset.NewMetaRow;
import kd.bos.algo.datatype.AnyType;
import kd.bos.algo.datatype.NumericType;

public class UnionDataSetBatch
extends AbstractDataSet {
    public UnionDataSetBatch(AbstractDataSet dataSet, DataSet ... otherDataSets) {
        super("Union", dataSet.getEnvironment(), UnionDataSetBatch.concatDataSets(dataSet, otherDataSets));
        this.makeRowMeta();
    }

    private static List<AbstractDataSet> concatDataSets(AbstractDataSet dataSet, DataSet ... otherDataSets) {
        ArrayList<AbstractDataSet> list = new ArrayList<AbstractDataSet>();
        list.add(dataSet);
        for (int i = 0; i < otherDataSets.length; ++i) {
            list.add((AbstractDataSet)otherDataSets[i]);
        }
        return list;
    }

    private void checkRowMeta(RowMeta rowMeta, RowMeta rowMeta2) {
        if (rowMeta.getFieldCount() != rowMeta2.getFieldCount()) {
            throw new AlgoException("union dataset must have same fields count");
        }
        for (int i = 0; i < rowMeta.getFieldCount(); ++i) {
            DataType dataType2;
            DataType dataType1 = rowMeta.getField(i).getDataType();
            if (dataType1.acceptsType(dataType2 = rowMeta2.getField(i).getDataType())) continue;
            throw new AlgoException(String.format("union dataset must have same field dataType, but %s<>%s for %s union %s", dataType1.getName(), dataType2.getName(), rowMeta.getField(i).getName(), rowMeta2.getField(i).getName()));
        }
    }

    private void makeRowMeta() {
        AbstractDataSet one = this.getInput(0);
        AbstractDataSet two = this.getInput(1);
        this.checkRowMeta(one.getRowMeta(), two.getRowMeta());
        Field[] fields1 = one.getRowMeta().getFields();
        Field[] fields2 = two.getRowMeta().getFields();
        Field[] fields = new Field[fields1.length];
        for (int i = 0; i < fields1.length; ++i) {
            fields[i] = fields1[i].copy();
            DataType dataType = fields1[i].getDataType();
            DataType dataType2 = fields2[i].getDataType();
            if (dataType == DataType.UnknownType || dataType == AnyType.instance) {
                if (dataType2 == DataType.UnknownType || dataType2 == AnyType.instance) {
                    throw new AlgoException("Union not support both unknowtype of field:" + fields[1].getAlias());
                }
                fields[i].setDataType(dataType2);
            }
            if (dataType == DataType.NullType) {
                fields[i].setDataType(dataType2);
            }
            if (!(dataType instanceof NumericType) || !(dataType2 instanceof NumericType)) continue;
            dataType = NumericType.computeCompatibleDown((NumericType)dataType, (NumericType)dataType2);
            fields[i].setDataType(dataType);
        }
        this.rowMeta = new RowMeta(fields);
    }

    @Override
    public RowMeta createTargetRowMeta() {
        return this.rowMeta;
    }

    @Override
    public InnerRowIterator createIterator() {
        this.checkClosed();
        ArrayList<InnerRowIterator> list = new ArrayList<InnerRowIterator>();
        for (AbstractDataSet input : this.getInputs()) {
            list.add(input.innerIterator());
        }
        final Iterator iter = Iterators.concat((Iterator[])list.toArray(new InnerRowIterator[list.size()]));
        final NewMetaRow cursor = new NewMetaRow(this.getRowMeta());
        return new InnerRowIterator(){

            @Override
            public boolean _hasNext() {
                return iter.hasNext();
            }

            @Override
            public Row _next() {
                Row innerRow = (Row)iter.next();
                cursor.setRow(innerRow);
                return cursor;
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public void realClose() {
    }
}

