/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.datatype;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.Timestamp;
import kd.bos.algo.DataType;
import kd.bos.algo.datatype.AnyType;
import kd.bos.algo.datatype.DateType;
import kd.bos.algo.datatype.NullType;
import kd.bos.algo.datatype.UnknownType;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class TimestampType
extends DataType {
    private static final long serialVersionUID = 1646847337667538699L;

    public TimestampType() {
        super(7, "Timestamp");
    }

    @Override
    public int getFixedSize() {
        return 8;
    }

    @Override
    public boolean acceptsType(DataType other) {
        if (other instanceof NullType || other instanceof AnyType || other instanceof UnknownType) {
            return true;
        }
        return other instanceof TimestampType || other instanceof DateType;
    }

    @Override
    public Class<?> getJavaType() {
        return Timestamp.class;
    }

    @Override
    public void write(Object value, DataOutput output) throws IOException {
        output.writeLong(((Timestamp)value).getTime());
    }

    @Override
    public Object read(DataInput input) throws IOException {
        long time = input.readLong();
        return new Timestamp(time);
    }

    @Override
    public int getSqlType() {
        return 93;
    }

    @Override
    public void write(Object value, DataOutputStream output) throws IOException {
        this.write(value, (DataOutput)output);
    }

    @Override
    public Object read(DataInputStream input) throws IOException {
        return this.read((DataInput)input);
    }
}

