/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.env;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.AlgoException;
import kd.bos.algo.dataset.store.Store;
import kd.bos.algo.env.Environment;
import kd.bos.util.ThreadLocals;
import org.apache.log4j.Logger;

public class ThreadContext
implements Closeable,
AutoCloseable {
    private static Logger logger = Logger.getLogger(ThreadContext.class);
    private static ThreadLocal<ThreadContext> tlContext = ThreadLocals.create(() -> new ThreadContext());
    private HashMap<String, Environment> envMap = new HashMap();
    private ArrayList<Closeable> allCloseable = new ArrayList();
    private HashMap<String, String> props = new HashMap();
    private ThreadContext root;
    private ThreadContext parent;
    private ThreadContext child;
    private ThreadContext current = this;

    ThreadContext newChild() {
        if (this.child != null) {
            throw new AlgoException("can't create multiple child context.");
        }
        ThreadContext context = new ThreadContext();
        context.parent = this;
        context.root = this.root != null ? this.root : this;
        context.root.current = context;
        this.child = context;
        return context;
    }

    public void setProperty(String key, String value) {
        this.props.put(key, value);
    }

    public String getProperty(String key) {
        return this.props.get(key);
    }

    public void addEnv(Environment env) {
        this.envMap.put(env.getConfig().getKey(), env);
    }

    private void removeEnv(Environment env) {
        this.envMap.remove(env.getConfig().getKey());
    }

    @Override
    public void close() {
        if (this.child != null) {
            this.child.close();
        }
        ArrayList<Environment> list = new ArrayList<Environment>(this.envMap.size());
        list.addAll(this.envMap.values());
        for (Environment env : list) {
            try {
                env.close();
            }
            catch (Throwable e) {
                logger.error((Object)e.getMessage(), e);
            }
        }
        this.envMap.clear();
        ArrayList<Closeable> toRemove = new ArrayList<Closeable>();
        toRemove.addAll(this.allCloseable);
        for (Closeable c : toRemove) {
            try {
                c.close();
            }
            catch (Throwable e) {
                logger.error((Object)e.getMessage(), e);
            }
        }
        if (this.parent != null) {
            this.parent.child = null;
            this.root.current = this.parent;
        }
    }

    public Environment getEnv(String key) {
        return this.envMap.get(key);
    }

    public void addStore(Store store) {
        this.allCloseable.add(store);
    }

    public void removeStore(Store store) {
        this.allCloseable.remove(store);
    }

    public void addCloseable(Closeable closeable) {
        this.allCloseable.add(closeable);
    }

    public void removeCloseable(Closeable closeable) {
        this.allCloseable.remove(closeable);
    }

    public static ThreadContext getCurrent() {
        return ThreadContext.tlContext.get().current;
    }

    public static void addEnvironment(Environment env) {
        ThreadContext.tlContext.get().current.addEnv(env);
    }

    public static void removeEnvironment(Environment env) {
        ThreadContext.tlContext.get().current.removeEnv(env);
    }

    public static void clear() {
        tlContext.get().close();
        tlContext.remove();
    }

    public static Map<String, Integer> getCurrentThreadDataSetSize() {
        ThreadContext current = ThreadContext.getCurrent();
        HashMap<String, Environment> envMap = current.envMap;
        Iterator<Map.Entry<String, Environment>> iterator = envMap.entrySet().iterator();
        HashMap<String, Integer> sizeMap = new HashMap<String, Integer>(envMap.size());
        while (iterator.hasNext()) {
            Map.Entry<String, Environment> next = iterator.next();
            Environment value = next.getValue();
            sizeMap.put(next.getKey(), value.getDataSetSize());
        }
        return sizeMap;
    }
}

