/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.serde;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.algo.dataset.RowFactory;
import kd.bos.algo.serde.RowSerde;

public class RawRowSerde
extends RowSerde {
    @Override
    public void write(RowMeta rowMeta, Row row, DataOutputStream out) {
        AbstractRow ar = (AbstractRow)row;
        Object[] values = ar.values();
        try {
            RawRowSerde.writeNullMask(values.length, values, out);
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == null) continue;
                rowMeta.getFieldDataType(i).write(DataType.convertValue(rowMeta.getFieldDataType(i), values[i]), out);
            }
        }
        catch (IOException e) {
            throw new AlgoException(e);
        }
    }

    @Override
    public Row read(RowMeta rowMeta, DataInputStream in) {
        try {
            int len = rowMeta.getFieldCount();
            boolean[] nullMask = new boolean[len];
            RawRowSerde.readIntoNullMask(len, in, nullMask);
            Object[] values = new Object[len];
            for (int i = 0; i < values.length; ++i) {
                if (nullMask[i]) continue;
                values[i] = rowMeta.getFieldDataType(i).read(in);
            }
            return RowFactory.createRow(rowMeta, values, false);
        }
        catch (IOException e) {
            throw new AlgoException(e);
        }
    }

    public static void writeNullMask(int len, Object[] values, DataOutput target) throws IOException {
        int b = 0;
        int bytePos = 0;
        int numPos = 0;
        for (int fieldPos = 0; fieldPos < len; fieldPos += numPos) {
            b = 0;
            numPos = Math.min(8, len - fieldPos);
            for (bytePos = 0; bytePos < numPos; ++bytePos) {
                b <<= 1;
                if (values[fieldPos + bytePos] != null) continue;
                b |= 1;
            }
            target.writeByte(b <<= 8 - bytePos);
        }
    }

    public static void readIntoNullMask(int len, DataInput source, boolean[] nullMask) throws IOException {
        int b = 0;
        int bytePos = 0;
        int numPos = 0;
        for (int fieldPos = 0; fieldPos < len; fieldPos += numPos) {
            b = source.readUnsignedByte();
            numPos = Math.min(8, len - fieldPos);
            for (bytePos = 0; bytePos < numPos; ++bytePos) {
                nullMask[fieldPos + bytePos] = (b & 0x80) > 0;
                b <<= 1;
            }
        }
    }
}

