/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.tree;

import java.util.ArrayList;
import java.util.Optional;
import kd.bos.algo.DataType;
import kd.bos.algo.sql.tree.AstVisitor;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.NodeLocation;
import kd.bos.algo.sql.tree.calc.AndCalc;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.sql.tree.calc.CompileContext;

public class And
extends Expr {
    public static And create(Optional<NodeLocation> location, Expr left, Expr right) {
        ArrayList<Expr> list = new ArrayList<Expr>();
        if (left instanceof And) {
            list.addAll(left.getChildren());
        } else {
            list.add(left);
        }
        if (right instanceof And) {
            list.addAll(right.getChildren());
        } else {
            list.add(right);
        }
        return new And(location, list.toArray(new Expr[list.size()]));
    }

    public And(Optional<NodeLocation> location, Expr[] children) {
        super(location, children, And.repeatDataTypes(DataType.BooleanType, children == null ? 0 : children.length));
    }

    @Override
    public String sql() {
        return ((NodeLocation)this.location.get()).getText();
    }

    @Override
    public DataType createDataType() {
        return DataType.BooleanType;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitAnd(this, context);
    }

    @Override
    public Calc compile(CompileContext context) {
        return new AndCalc(this, this.compileChildren(context));
    }
}

