/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.tree;

import java.util.Optional;
import kd.bos.algo.DataType;
import kd.bos.algo.datatype.AnyType;
import kd.bos.algo.sql.tree.AstVisitor;
import kd.bos.algo.sql.tree.CaseWhenClause;
import kd.bos.algo.sql.tree.CaseWhenTypes;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.NodeLocation;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.sql.tree.calc.CaseWhenSimpleCalc;
import kd.bos.algo.sql.tree.calc.CaseWhenSimpleWithElseCalc;
import kd.bos.algo.sql.tree.calc.CompileContext;

public class CaseWhenSimple
extends Expr {
    private boolean hasElse;
    private CaseWhenClause[] whenClauses;

    public CaseWhenSimple(Optional<NodeLocation> location, Expr valueExpr, CaseWhenClause[] whenClauses) {
        super(location, CaseWhenSimple.concatExprs(valueExpr, whenClauses), CaseWhenSimple.repeatDataTypes(AnyType.instance, whenClauses.length + 1));
        this.whenClauses = whenClauses;
    }

    public CaseWhenSimple(Optional<NodeLocation> location, Expr valueExpr, CaseWhenClause[] whenClauses, Expr elseExpr) {
        super(location, CaseWhenSimple.concatExprs(valueExpr, whenClauses, elseExpr), CaseWhenSimple.repeatDataTypes(AnyType.instance, whenClauses.length + 2));
        this.whenClauses = whenClauses;
        this.hasElse = true;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCaseWhenSimple(this, context);
    }

    @Override
    public DataType createDataType() {
        return CaseWhenTypes.guessDataType(this, this.whenClauses, this.hasElse);
    }

    @Override
    public String sql() {
        StringBuilder sql = new StringBuilder("CASE ");
        sql.append(this.children[0].sql());
        int length = this.hasElse ? this.children.length - 1 : this.children.length - 2;
        for (int i = 0; i < length; ++i) {
            sql.append(" ").append(this.children[i + 1].sql());
        }
        if (this.hasElse) {
            sql.append(" ELSE ").append(this.children[this.children.length - 1].sql());
        }
        sql.append(" END");
        return sql.toString();
    }

    public boolean hasElse() {
        return this.hasElse;
    }

    @Override
    public Calc compile(CompileContext context) {
        int length = this.hasElse ? this.children.length - 2 : this.children.length - 1;
        Calc[] conditionCalcs = new Calc[length];
        Calc[] resultCalcs = new Calc[length];
        Calc valueCalc = this.children[0].compile(context);
        for (int i = 0; i < length; ++i) {
            CaseWhenClause clause = (CaseWhenClause)this.children[i + 1];
            conditionCalcs[i] = clause.getConditionExpr().compile(context);
            resultCalcs[i] = clause.getResultExpr().compile(context);
        }
        if (this.hasElse) {
            Calc elseCalc = this.children[this.children.length - 1].compile(context);
            return new CaseWhenSimpleWithElseCalc(this, valueCalc, conditionCalcs, resultCalcs, elseCalc);
        }
        return new CaseWhenSimpleCalc(this, valueCalc, conditionCalcs, resultCalcs);
    }
}

