/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.tree;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataType;
import kd.bos.algo.sql.Interpret;
import kd.bos.algo.sql.resolve.Resolver;
import kd.bos.algo.sql.tree.Node;
import kd.bos.algo.sql.tree.NodeLocation;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.sql.tree.calc.CalcCompileable;
import kd.bos.algo.sql.tree.calc.CompileContext;

public abstract class Expr
extends Node
implements Interpret,
CalcCompileable {
    protected DataType[] inputTypes;
    protected Expr[] children;
    private DataType dataType;
    private boolean hasCheckAcceptsTypes = false;

    public Expr(Optional<NodeLocation> location, Expr child, DataType inputType) {
        this(location, new Expr[]{child}, new DataType[]{inputType});
    }

    public Expr(Optional<NodeLocation> location, Expr[] children, DataType[] inputTypes) {
        super(location);
        this.children = children;
        this.inputTypes = inputTypes;
    }

    public List<Expr> getChildren() {
        if (this.children != null) {
            return ImmutableList.copyOf((Object[])this.children);
        }
        return ImmutableList.of();
    }

    public int getChildrenCount() {
        if (this.children == null) {
            return this.getChildren().size();
        }
        return this.children.length;
    }

    public Expr getChild(int index) {
        if (this.children != null) {
            return this.children[index];
        }
        return this.getChildren().get(index);
    }

    public void replaceChild(int index, Expr expr) {
        if (this.children == null) {
            throw new AlgoException("children is null.");
        }
        if (index > this.children.length || index < 0) {
            throw new AlgoException(String.format("Index %d out of children bound [%d:%d]", index, 0, this.children.length));
        }
        this.children[index] = expr;
    }

    public DataType getDataType() {
        if (this.dataType == null) {
            this.dataType = this.createDataType();
        }
        return this.dataType;
    }

    protected abstract DataType createDataType();

    public void checkInputTypes() {
        DataType[] inputTypes = this.getInputTypes();
        if (this.children != null) {
            if (inputTypes == null) {
                throw new AlgoException("inputTypes can't be null.");
            }
            if (inputTypes.length != this.children.length) {
                throw AlgoException.create(this.toString() + "inputTypes length should equals to children length, but %d<>%d", inputTypes.length, this.children.length);
            }
            for (int i = 0; i < inputTypes.length; ++i) {
                if (this.children[i] != null) {
                    if (inputTypes[i].acceptsType(this.children[i].getDataType())) continue;
                    throw AlgoException.create(this.toString() + " DataType not compatible, %s should be %s, but %s found.", this.children[i].toString(), inputTypes[i].getName(), this.children[i].getDataType());
                }
                if (inputTypes[i].acceptsType(DataType.NullType)) continue;
                throw AlgoException.create(this.toString() + " %dth argument can't be null, but null found.", i);
            }
        }
    }

    public DataType[] getInputTypes() {
        return this.inputTypes;
    }

    protected Calc[] compileChildren(CompileContext context) {
        if (this.children != null) {
            Calc[] result = new Calc[this.children.length];
            for (int i = 0; i < this.children.length; ++i) {
                if (this.children[i] == null) continue;
                result[i] = this.children[i].compile(context);
            }
            return result;
        }
        return null;
    }

    public abstract String sql();

    public String toString() {
        if (this.location.isPresent()) {
            return ((NodeLocation)this.location.get()).getText();
        }
        return this.sql();
    }

    public boolean equals(Object x) {
        if (x instanceof Expr) {
            return Objects.equals(this.sql(), ((Expr)x).sql());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.sql());
    }

    public String joinChildrenSql(Expr[] children) {
        return this.joinChildrenSql(children, ",");
    }

    public String joinChildrenSql(Expr[] children, String delimiter) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < children.length; ++i) {
            if (i > 0) {
                sb.append(delimiter);
            }
            sb.append(children[i].sql());
        }
        return sb.toString();
    }

    protected Calc compileChild(CompileContext ctx, int index) {
        return this.compileChild(ctx, this.children[index], this.inputTypes[index]);
    }

    private void checkAcceptsTypes() {
        if (this.hasCheckAcceptsTypes) {
            return;
        }
        for (int i = 0; i < this.children.length; ++i) {
            this.checkAcceptsType(this.children[i], this.inputTypes[i]);
        }
        this.hasCheckAcceptsTypes = true;
    }

    private void checkAcceptsType(Expr child, DataType inputType) {
        if (!inputType.acceptsType(child.getDataType())) {
            throw AlgoException.create("expr %s should be %s, but %s found.", child.toString(), inputType.getName(), child.getDataType().getName());
        }
    }

    private Calc compileChild(CompileContext ctx, Expr child, DataType inputType) {
        this.checkAcceptsTypes();
        return child.compile(ctx);
    }

    public static Expr[] concatExprs(Expr expr0, Expr[] exprs) {
        Expr[] results = new Expr[exprs.length + 1];
        results[0] = expr0;
        System.arraycopy(exprs, 0, results, 1, exprs.length);
        return results;
    }

    public static Expr[] concatExprs(Expr expr0, Expr[] exprs, Expr expr2) {
        Expr[] results = new Expr[exprs.length + 2];
        results[0] = expr0;
        System.arraycopy(exprs, 0, results, 1, exprs.length);
        results[results.length - 1] = expr2;
        return results;
    }

    public static Expr[] concatExprs(Expr[] exprs, Expr expr2) {
        Expr[] results = new Expr[exprs.length + 1];
        System.arraycopy(exprs, 0, results, 0, exprs.length);
        results[results.length - 1] = expr2;
        return results;
    }

    public static DataType[] concatDataTypes(DataType dataType0, DataType[] dataTypes) {
        DataType[] results = new DataType[dataTypes.length + 1];
        results[0] = dataType0;
        System.arraycopy(dataTypes, 0, results, 1, dataTypes.length);
        return results;
    }

    public static DataType[] repeatDataTypes(DataType dataType, int n) {
        if (n == 0) {
            return null;
        }
        DataType[] inputTypes = new DataType[n];
        for (int i = 0; i < inputTypes.length; ++i) {
            inputTypes[i] = dataType;
        }
        return inputTypes;
    }

    public Expr resolve(Resolver ... resolvers) {
        Expr expr = this;
        for (Resolver resolver : resolvers) {
            expr = resolver.resolve(expr);
        }
        return expr;
    }

    @Override
    public Optional<NodeLocation> getLocation() {
        return super.getLocation();
    }
}

