/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import kd.bos.algo.sql.tree.AstVisitor;
import kd.bos.algo.sql.tree.GroupingElement;
import kd.bos.algo.sql.tree.Node;
import kd.bos.algo.sql.tree.NodeLocation;

public class GroupBy
extends Node {
    private final boolean isDistinct;
    private final List<GroupingElement> groupingElements;

    public GroupBy(boolean isDistinct, List<GroupingElement> groupingElements) {
        this(Optional.empty(), isDistinct, groupingElements);
    }

    public GroupBy(NodeLocation location, boolean isDistinct, List<GroupingElement> groupingElements) {
        this(Optional.of(location), isDistinct, groupingElements);
    }

    public GroupBy(Optional<NodeLocation> location, boolean isDistinct, List<GroupingElement> groupingElements) {
        super(location);
        this.isDistinct = isDistinct;
        this.groupingElements = ImmutableList.copyOf((Collection)Objects.requireNonNull(groupingElements));
    }

    public boolean isDistinct() {
        return this.isDistinct;
    }

    public List<GroupingElement> getGroupingElements() {
        return this.groupingElements;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitGroupBy(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return this.groupingElements;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupBy groupBy = (GroupBy)o;
        return this.isDistinct == groupBy.isDistinct && Objects.equals(this.groupingElements, groupBy.groupingElements);
    }

    public int hashCode() {
        return Objects.hash(this.isDistinct, this.groupingElements);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("isDistinct", this.isDistinct).add("groupingElements", this.groupingElements).toString();
    }
}

