/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.tree;

import java.util.Optional;
import kd.bos.algo.DataType;
import kd.bos.algo.datatype.AnyType;
import kd.bos.algo.sql.tree.AstVisitor;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.ExprList;
import kd.bos.algo.sql.tree.NodeLocation;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.sql.tree.calc.CompileContext;
import kd.bos.algo.sql.tree.calc.InCalc;
import kd.bos.algo.sql.tree.calc.TupleInCalc;

public class In
extends Expr {
    public In(Optional<NodeLocation> location, Expr value, Expr[] list) {
        super(location, In.concatExprs(value, list), In.repeatDataTypes(AnyType.instance, list.length + 1));
    }

    @Override
    public String sql() {
        StringBuilder listSql = new StringBuilder();
        for (int i = 1; i < this.children.length; ++i) {
            if (i > 1) {
                listSql.append(',');
            }
            listSql.append(this.children[i].sql());
        }
        return this.children[0].sql() + " IN (" + listSql + ")";
    }

    @Override
    public DataType createDataType() {
        return DataType.BooleanType;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitIn(this, context);
    }

    @Override
    public Calc compile(CompileContext context) {
        if (this.children[0] instanceof ExprList && ((ExprList)this.children[0]).getChildrenCount() > 1) {
            return new TupleInCalc(this, this.compileChildren(context));
        }
        return new InCalc(this, this.compileChildren(context));
    }
}

