/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.tree;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Optional;
import kd.bos.algo.DataType;
import kd.bos.algo.sql.tree.AstVisitor;
import kd.bos.algo.sql.tree.LeafExpr;
import kd.bos.algo.sql.tree.NodeLocation;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.sql.tree.calc.CompileContext;
import kd.bos.algo.sql.tree.calc.ConstantCalc;

public class Literal
extends LeafExpr {
    private Object value;
    private DataType dataType;

    public Literal(Optional<NodeLocation> location, Object value, DataType dataType) {
        super(location);
        this.value = value;
        this.dataType = dataType;
    }

    private static String handleQuote(String value) {
        return value.replaceAll("\\\\'", "'");
    }

    public Literal(Optional<NodeLocation> location, String value) {
        this(location, Literal.handleQuote(value), (DataType)DataType.StringType);
    }

    public Literal(Optional<NodeLocation> location, Integer value) {
        this(location, value, (DataType)DataType.IntegerType);
    }

    public Literal(Optional<NodeLocation> location, Long value) {
        this(location, value, (DataType)DataType.LongType);
    }

    public Literal(Optional<NodeLocation> location, Double value) {
        this(location, value, (DataType)DataType.DoubleType);
    }

    public Literal(Optional<NodeLocation> location, BigDecimal value) {
        this(location, value, (DataType)DataType.BigDecimalType);
    }

    public Literal(Optional<NodeLocation> location, Float value) {
        this(location, value.doubleValue(), (DataType)DataType.DoubleType);
    }

    public Literal(Optional<NodeLocation> location, Boolean value) {
        this(location, value, (DataType)DataType.BooleanType);
    }

    public Literal(Optional<NodeLocation> location, Date value) {
        this(location, value, (DataType)DataType.DateType);
    }

    public Literal(Optional<NodeLocation> location, Timestamp value) {
        this(location, value, (DataType)DataType.TimestampType);
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public DataType createDataType() {
        return this.dataType;
    }

    @Override
    public String sql() {
        if (DataType.NullType == this.dataType) {
            return "NULL";
        }
        if (DataType.StringType == this.dataType) {
            return "'" + this.value + "'";
        }
        return this.value.toString();
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitLiteral(this, context);
    }

    @Override
    public Calc compile(CompileContext context) {
        return new ConstantCalc(this, this.value);
    }
}

