/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import kd.bos.algo.sql.tree.AstVisitor;
import kd.bos.algo.sql.tree.Node;
import kd.bos.algo.sql.tree.NodeLocation;
import kd.bos.algo.sql.tree.SortItem;

public class OrderBy
extends Node {
    private List<SortItem> sortItems;

    public OrderBy(List<SortItem> sortItems) {
        this(Optional.empty(), sortItems);
    }

    public OrderBy(NodeLocation location, List<SortItem> sortItems) {
        this(Optional.of(location), sortItems);
    }

    public OrderBy(Optional<NodeLocation> location, List<SortItem> sortItems) {
        super(location);
        Objects.requireNonNull(sortItems, "sortItems is null");
        Preconditions.checkArgument((!sortItems.isEmpty() ? 1 : 0) != 0, (Object)"sortItems should not be empty");
        this.sortItems = ImmutableList.copyOf(sortItems);
    }

    public List<SortItem> getSortItems() {
        return ImmutableList.copyOf(this.sortItems);
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitOrderBy(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return this.getSortItems();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sortItems", this.sortItems).toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OrderBy o = (OrderBy)obj;
        return Objects.equals(this.sortItems, o.sortItems);
    }

    public int hashCode() {
        return Objects.hash(this.sortItems);
    }
}

