/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.tree;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public class QualifiedName {
    private final List<String> parts;
    private final List<String> originalParts;

    public static QualifiedName of(String first, String ... rest) {
        Objects.requireNonNull(first, "first is null");
        return QualifiedName.of((Iterable<String>)ImmutableList.copyOf((Collection)Lists.asList((Object)first, (Object[])rest)));
    }

    public static QualifiedName of(String name) {
        Objects.requireNonNull(name, "name is null");
        return QualifiedName.of((Iterable<String>)ImmutableList.of((Object)name));
    }

    public static QualifiedName of(String[] names) {
        Objects.requireNonNull(names, "name is null");
        return QualifiedName.of((Iterable<String>)ImmutableList.copyOf((Object[])names));
    }

    public static QualifiedName of(Iterable<String> originalParts) {
        Objects.requireNonNull(originalParts, "originalParts is null");
        Preconditions.checkArgument((!Iterables.isEmpty(originalParts) ? 1 : 0) != 0, (Object)"originalParts is empty");
        ImmutableList parts = ImmutableList.copyOf((Iterable)Iterables.transform(originalParts, part -> part.toLowerCase(Locale.ENGLISH)));
        return new QualifiedName((List<String>)ImmutableList.copyOf(originalParts), (List<String>)parts);
    }

    private QualifiedName(List<String> originalParts, List<String> parts) {
        this.originalParts = originalParts;
        this.parts = parts;
    }

    public List<String> getOriginalParts() {
        return this.originalParts;
    }

    public String toString() {
        return Joiner.on((char)'.').join(this.parts);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.parts.equals(((QualifiedName)o).parts);
    }

    public int hashCode() {
        return this.parts.hashCode();
    }
}

