/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import kd.bos.algo.sql.tree.AstVisitor;
import kd.bos.algo.sql.tree.Node;
import kd.bos.algo.sql.tree.NodeLocation;
import kd.bos.algo.sql.tree.QueryBody;
import kd.bos.algo.sql.tree.Statement;

public class Query
extends Statement {
    private QueryBody queryBody;

    public Query(QueryBody queryBody) {
        this(Optional.empty(), queryBody);
    }

    public Query(NodeLocation location, QueryBody queryBody) {
        this(Optional.of(location), queryBody);
    }

    public Query(Optional<NodeLocation> location, QueryBody queryBody) {
        super(location);
        Objects.requireNonNull(queryBody, "queryBody is null");
        this.queryBody = queryBody;
    }

    public QueryBody getQueryBody() {
        return this.queryBody;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitQuery(this, context);
    }

    public List<Node> getChildren() {
        ImmutableList.Builder nodes = ImmutableList.builder();
        nodes.add((Object)this.queryBody);
        return nodes.build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("queryBody", (Object)this.queryBody).omitNullValues().toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Query o = (Query)obj;
        return Objects.equals(this.queryBody, o.queryBody);
    }

    public int hashCode() {
        return Objects.hash(this.queryBody);
    }
}

