/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import kd.bos.algo.sql.tree.AstVisitor;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.GroupBy;
import kd.bos.algo.sql.tree.Limit;
import kd.bos.algo.sql.tree.Node;
import kd.bos.algo.sql.tree.NodeLocation;
import kd.bos.algo.sql.tree.OrderBy;
import kd.bos.algo.sql.tree.QueryBody;
import kd.bos.algo.sql.tree.Relation;
import kd.bos.algo.sql.tree.Select;

public class QuerySpecification
extends QueryBody {
    private Select select;
    private Optional<Relation> from;
    private Optional<Expr> where;
    private Optional<GroupBy> groupBy;
    private Optional<Expr> having;
    private Optional<OrderBy> orderBy;
    private Optional<Limit> limit;

    public QuerySpecification(Select select, Optional<Relation> from, Optional<Expr> where, Optional<GroupBy> groupBy, Optional<Expr> having, Optional<OrderBy> orderBy, Optional<Limit> limit) {
        this(Optional.empty(), select, from, where, groupBy, having, orderBy, limit);
    }

    public QuerySpecification(NodeLocation location, Select select, Optional<Relation> from, Optional<Expr> where, Optional<GroupBy> groupBy, Optional<Expr> having, Optional<OrderBy> orderBy, Optional<Limit> limit) {
        this(Optional.of(location), select, from, where, groupBy, having, orderBy, limit);
    }

    public QuerySpecification(Optional<NodeLocation> location, Select select, Optional<Relation> from, Optional<Expr> where, Optional<GroupBy> groupBy, Optional<Expr> having, Optional<OrderBy> orderBy, Optional<Limit> limit) {
        super(location);
        Objects.requireNonNull(select, "select is null");
        Objects.requireNonNull(from, "from is null");
        Objects.requireNonNull(where, "where is null");
        Objects.requireNonNull(groupBy, "groupBy is null");
        Objects.requireNonNull(having, "having is null");
        Objects.requireNonNull(orderBy, "orderBy is null");
        Objects.requireNonNull(limit, "limit is null");
        this.select = select;
        this.from = from;
        this.where = where;
        this.groupBy = groupBy;
        this.having = having;
        this.orderBy = orderBy;
        this.limit = limit;
    }

    public Select getSelect() {
        return this.select;
    }

    public Optional<Relation> getFrom() {
        return this.from;
    }

    public Optional<Expr> getWhere() {
        return this.where;
    }

    public Optional<GroupBy> getGroupBy() {
        return this.groupBy;
    }

    public Optional<Expr> getHaving() {
        return this.having;
    }

    public Optional<OrderBy> getOrderBy() {
        return this.orderBy;
    }

    public Optional<Limit> getLimit() {
        return this.limit;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitQuerySpecification(this, context);
    }

    public List<Node> getChildren() {
        ImmutableList.Builder nodes = ImmutableList.builder();
        nodes.add((Object)this.select);
        this.from.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        this.where.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        this.groupBy.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        this.having.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        this.orderBy.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        return nodes.build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("select", (Object)this.select).add("from", this.from).add("where", this.where.orElse(null)).add("groupBy", this.groupBy).add("having", this.having.orElse(null)).add("orderBy", this.orderBy).add("limit", this.limit.orElse(null)).toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QuerySpecification o = (QuerySpecification)obj;
        return Objects.equals(this.select, o.select) && Objects.equals(this.from, o.from) && Objects.equals(this.where, o.where) && Objects.equals(this.groupBy, o.groupBy) && Objects.equals(this.having, o.having) && Objects.equals(this.orderBy, o.orderBy) && Objects.equals(this.limit, o.limit);
    }

    public int hashCode() {
        return Objects.hash(this.select, this.from, this.where, this.groupBy, this.having, this.orderBy, this.limit);
    }
}

