/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import kd.bos.algo.sql.tree.AstVisitor;
import kd.bos.algo.sql.tree.Node;
import kd.bos.algo.sql.tree.NodeLocation;
import kd.bos.algo.sql.tree.QualifiedName;
import kd.bos.algo.sql.tree.QueryBody;

public class Table
extends QueryBody {
    private final QualifiedName name;

    public Table(QualifiedName name) {
        this(Optional.empty(), name);
    }

    public Table(NodeLocation location, QualifiedName name) {
        this(Optional.of(location), name);
    }

    public Table(Optional<NodeLocation> location, QualifiedName name) {
        super(location);
        this.name = name;
    }

    public QualifiedName getName() {
        return this.name;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitTable(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.name).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Table table = (Table)o;
        return Objects.equals(this.name, table.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

