/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.tree;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataType;
import kd.bos.algo.sql.schema.Column;
import kd.bos.algo.sql.schema.Schema;
import kd.bos.algo.sql.schema.Table;
import kd.bos.algo.sql.tree.AstVisitor;
import kd.bos.algo.sql.tree.Attribute;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.Keyword;
import kd.bos.algo.sql.tree.NodeLocation;
import kd.bos.algo.sql.tree.Unresolved;
import kd.bos.algo.sql.tree.bind.ColumnRef;
import kd.bos.algo.sql.tree.bind.ParamRef;
import kd.bos.algo.sql.tree.bind.RelationRef;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.sql.tree.calc.CompileContext;

public class UnresolvedAttribute
extends Attribute
implements Unresolved {
    private List<String> nameParts = new ArrayList<String>(2);
    private String fullName;

    public UnresolvedAttribute(Optional<NodeLocation> location, String ... nameParts) {
        super(location);
        for (String name : nameParts) {
            this.nameParts.add(name);
        }
        this.fullName = String.join((CharSequence)".", nameParts);
    }

    public UnresolvedAttribute(Optional<NodeLocation> location, List<String> nameParts) {
        super(location);
        this.nameParts = nameParts;
        this.fullName = String.join((CharSequence)".", nameParts);
    }

    public List<String> getNameParts() {
        return new ArrayList<String>(this.nameParts);
    }

    @Override
    public String sql() {
        return this.fullName;
    }

    public UnresolvedAttribute derive(Optional<NodeLocation> location, String part) {
        ArrayList<String> copyNameParts = new ArrayList<String>(this.nameParts.size());
        copyNameParts.addAll(this.nameParts);
        copyNameParts.add(part);
        return new UnresolvedAttribute(location, copyNameParts);
    }

    @Override
    public DataType createDataType() {
        return DataType.UnknownType;
    }

    @Override
    public Expr resolve(Schema schema) {
        return this.resolve0(schema, true);
    }

    private Expr resolve0(Schema schema, boolean exception) {
        Object t = schema.getColumn(this.nameParts.toArray(new String[this.nameParts.size()]));
        if (t == null && this.nameParts.size() == 1 && (t = Keyword.of(this.nameParts.get(0))) != null) {
            return (Expr)t;
        }
        if (t == null) {
            if (exception) {
                String message = "Illegal field:" + this.sql();
                if (this.getLocation().isPresent()) {
                    message = message + ", at " + this.getLocation().get().getText();
                }
                throw new AlgoException(message);
            }
            return null;
        }
        if (t instanceof Column) {
            return new ColumnRef(this.getLocation(), (Column)t, this.fullName);
        }
        if (t instanceof Table) {
            return new RelationRef(this.getLocation(), (Table)t);
        }
        return null;
    }

    public Expr resolve(Schema schema, Map<String, Object> params) {
        Object value;
        if (params != null && (value = params.get(this.fullName)) != null) {
            return new ParamRef(this.getLocation(), this.fullName, value);
        }
        return this.resolve(schema);
    }

    public Expr resolve(Schema schema, Schema right, boolean checkAmbiguous) {
        Expr expr = this.resolve0(schema, false);
        if (expr != null) {
            return expr;
        }
        expr = this.resolve0(right, false);
        if (expr == null) {
            throw new AlgoException("Illegal field: " + this.fullName);
        }
        return expr;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitUnresolvedAttribute(this, context);
    }

    @Override
    public Calc compile(CompileContext context) {
        throw new AlgoException("Not supported !");
    }
}

