/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.tree;

import java.util.Optional;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataType;
import kd.bos.algo.sql.schema.Schema;
import kd.bos.algo.sql.schema.Table;
import kd.bos.algo.sql.tree.AstVisitor;
import kd.bos.algo.sql.tree.Attribute;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.NodeLocation;
import kd.bos.algo.sql.tree.Unresolved;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.sql.tree.calc.CompileContext;
import kd.bos.algo.sql.tree.star.RelationAllColumn;
import kd.bos.algo.sql.tree.star.SchemaAllColumn;

public class UnresolvedStar
extends Attribute
implements Unresolved {
    private String prefix;

    public UnresolvedStar(Optional<NodeLocation> location, String prefix) {
        super(location);
        this.prefix = prefix;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitUnresolvedStar(this, context);
    }

    @Override
    public Expr resolve(Schema schema) {
        if (this.prefix != null) {
            Table relation = schema.getTable(this.prefix);
            if (relation == null) {
                throw new AlgoException("Illegal \"" + this.prefix + ".*\"");
            }
            return new RelationAllColumn(this.getLocation(), relation);
        }
        return new SchemaAllColumn(this.getLocation(), schema);
    }

    @Override
    public DataType createDataType() {
        return null;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String sql() {
        return this.prefix == null ? "*" : this.prefix + ".*";
    }

    @Override
    public Calc compile(CompileContext context) {
        throw new AlgoException("Not supported !");
    }
}

