/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.tree.calc;

import java.math.BigDecimal;
import kd.bos.algo.RowFeature;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.util.AlgoUtil;

public class AddCalc
extends Calc {
    private Calc calc1;
    private Calc calc2;

    public AddCalc(Expr expr, Calc calc1, Calc calc2) {
        super(expr);
        this.calc1 = calc1;
        this.calc2 = calc2;
    }

    @Override
    public final Object executeImpl(RowFeature row1, RowFeature row2) {
        Object left = this.calc1.execute(row1, row2);
        Object right = this.calc2.execute(row1, row2);
        if (left == null && right == null) {
            return null;
        }
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        if (left instanceof BigDecimal || right instanceof BigDecimal) {
            return AlgoUtil.toBigDecimal(left).add(AlgoUtil.toBigDecimal(right));
        }
        if (left instanceof Long || right instanceof Long) {
            return ((Number)left).longValue() + ((Number)right).longValue();
        }
        if (left instanceof Integer || right instanceof Integer) {
            return ((Number)left).intValue() + ((Number)right).intValue();
        }
        if (left instanceof Double || right instanceof Double) {
            return ((Number)left).doubleValue() + ((Number)right).doubleValue();
        }
        return this.wrapException("+ only support Number.");
    }
}

