/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.tree.calc;

import kd.bos.algo.AlgoException;
import kd.bos.algo.RowFeature;
import kd.bos.algo.sql.tree.Expr;

public abstract class Calc {
    protected Expr expr;

    public Calc(Expr expr) {
        this.expr = expr;
    }

    public final Object execute(RowFeature row1, RowFeature row2) {
        try {
            return this.executeImpl(row1, row2);
        }
        catch (RuntimeException e) {
            if (e instanceof AlgoException) {
                throw e;
            }
            throw this.wrapException(e, row1, row2);
        }
    }

    protected void throwException(String message) {
        throw this.wrapException(message);
    }

    protected RuntimeException wrapException(String message) {
        if (this.expr == null || !this.expr.getLocation().isPresent()) {
            return new AlgoException(message);
        }
        StringBuilder sb = new StringBuilder(message);
        sb.append(",Expression:").append(this.expr.getLocation().get().getText());
        return new AlgoException(sb.toString());
    }

    protected RuntimeException wrapException(RuntimeException e) {
        if (this.expr == null || !this.expr.getLocation().isPresent()) {
            return e;
        }
        StringBuilder message = new StringBuilder(e.getMessage());
        message.append(",Expression:").append(this.expr.getLocation().get().getText());
        return new AlgoException(message.toString(), e);
    }

    protected RuntimeException wrapException(RuntimeException e, RowFeature row1, RowFeature row2) {
        if (this.expr == null || !this.expr.getLocation().isPresent()) {
            return e;
        }
        StringBuilder message = new StringBuilder(e.getMessage());
        message.append(",Expression:").append(this.expr.getLocation().get().getText()).append(",");
        if (row2 == null) {
            message.append("Row=").append(row1.toString());
        } else {
            message.append("Row1=").append(row1.toString()).append("Row2=").append(row2.toString());
        }
        return new AlgoException(message.toString(), e);
    }

    protected abstract Object executeImpl(RowFeature var1, RowFeature var2);
}

