/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.tree.calc;

import kd.bos.algo.RowFeature;
import kd.bos.algo.sql.interpret.ExplicitCheck;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.calc.Calc;

public final class ContainsCalc
extends Calc {
    private Calc calc1;
    private Calc calc2;

    public ContainsCalc(Expr expr, Calc calc1, Calc calc2) {
        super(expr);
        this.calc1 = calc1;
        this.calc2 = calc2;
    }

    @Override
    public Object executeImpl(RowFeature row1, RowFeature row2) {
        Object left = this.calc1.execute(row1, row2);
        if (left == null) {
            return Boolean.FALSE;
        }
        Object right = this.calc2.execute(row1, row2);
        if (right == null) {
            return Boolean.FALSE;
        }
        String leftStr = ExplicitCheck.checkString(left, "Contains argument should be String, but %s found.", this.expr);
        String rightStr = ExplicitCheck.checkString(right, "Contains argument should be String, but %s found.", this.expr);
        return leftStr.contains(rightStr);
    }
}

