/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.tree.calc;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.algo.RowFeature;
import kd.bos.algo.config.AlgoConfiguration;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.util.ResultEnum;
import kd.bos.algo.util.trie.TrieTree;

public class CountDistinctCalc
extends Calc {
    private int[] groupFieldIndices;
    private int[] distinctFieldIndices;
    private TrieTree tree;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private int maxSize = AlgoConfiguration.COUNTDISTINCT_TRIE_MAXSIZE.getInt();

    public CountDistinctCalc(Expr expr, int[] groupFieldIndices, int[] distinctFieldIndices) {
        super(expr);
        this.groupFieldIndices = groupFieldIndices;
        this.distinctFieldIndices = distinctFieldIndices;
        this.tree = new TrieTree();
    }

    @Override
    protected Object executeImpl(RowFeature row1, RowFeature row2) {
        StringBuilder builder = new StringBuilder();
        for (int index : this.groupFieldIndices) {
            builder.append(row1.get(index)).append("`");
        }
        for (int index : this.distinctFieldIndices) {
            builder.append(this.getKey(row1.get(index))).append("`");
        }
        String value = builder.toString();
        if (!this.tree.search(value)) {
            long size = this.tree.size();
            if (size < (long)this.maxSize) {
                this.tree.insert(value);
            }
            return ResultEnum.NOT_EXISTS;
        }
        return ResultEnum.EXISTS;
    }

    private Object getKey(Object o) {
        if (o instanceof BigDecimal) {
            return ((BigDecimal)o).stripTrailingZeros().toPlainString();
        }
        if (o instanceof Date) {
            return this.sdf.format((Date)o);
        }
        if (o instanceof Timestamp) {
            return this.sdf.format((Timestamp)o);
        }
        return o;
    }

    public long getTrieTreeSize() {
        return this.tree.size();
    }

    public int[] getDistinctFieldIndices() {
        return this.distinctFieldIndices;
    }
}

