/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.tree.calc;

import kd.bos.algo.RowFeature;
import kd.bos.algo.sql.interpret.ExplicitCheck;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.calc.Calc;

public final class LikeCalc
extends Calc {
    private Calc calc1;
    private Calc calc2;

    public LikeCalc(Expr expr, Calc calc1, Calc calc2) {
        super(expr);
        this.calc1 = calc1;
        this.calc2 = calc2;
    }

    @Override
    public Object executeImpl(RowFeature row1, RowFeature row2) {
        Object left = this.calc1.execute(row1, row2);
        if (left == null) {
            return Boolean.FALSE;
        }
        left = ExplicitCheck.checkString(left, "Like must be String, but %s found.", this.expr);
        Object right = ExplicitCheck.checkNotNull(this.calc2.execute(row1, row2), "Like pattern can't be null.", this.expr);
        right = ExplicitCheck.checkString(right, "Like pattern must be String, but %s found.", this.expr);
        String pattern = right.toString().trim();
        boolean leftLike = false;
        boolean rightLike = false;
        if (pattern.startsWith("%")) {
            leftLike = true;
            pattern = pattern.substring(1);
        }
        if (pattern.endsWith("%")) {
            rightLike = true;
            pattern = pattern.substring(0, pattern.length() - 1);
        }
        if (leftLike && rightLike) {
            return left.toString().contains(pattern);
        }
        if (leftLike) {
            return left.toString().endsWith(pattern);
        }
        if (rightLike) {
            return left.toString().startsWith(pattern);
        }
        return left.equals(pattern);
    }
}

