/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.tree.calc;

import java.math.BigDecimal;
import java.util.HashSet;
import kd.bos.algo.RowFeature;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.util.AlgoUtil;

public final class TupleInCalc
extends Calc {
    private Calc[] children;
    private HashSet<Object> set;
    private int size;
    private InKey cacheKey;

    public TupleInCalc(Expr expr, Calc[] children) {
        super(expr);
        this.children = children;
        this.size = expr.getChild(0).getChildrenCount();
        this.cacheKey = new InKey(this.size);
    }

    @Override
    public Object executeImpl(RowFeature row1, RowFeature row2) {
        Object[] values = (Object[])this.children[0].execute(row1, row2);
        if (this.set == null) {
            this.buildSet(row1, row2);
        }
        return this.set.contains(this.wrapKey(values));
    }

    private Object wrapKey(Object[] values) {
        this.cacheKey.setValues(values);
        return this.cacheKey;
    }

    private void buildSet(RowFeature row1, RowFeature row2) {
        this.set = new HashSet();
        for (int i = 1; i < this.children.length; ++i) {
            Object[] values = (Object[])this.children[i].execute(row1, row2);
            this.set.add(this.makeKey(values));
        }
    }

    private Object makeKey(Object[] values) {
        return new InKey(values);
    }

    private class InKey {
        private Object[] array;
        private int hashCode;
        private boolean wongSize;

        InKey(int size) {
            this.array = new Object[size];
        }

        InKey(Object[] values) {
            if (values.length != TupleInCalc.this.size) {
                this.wongSize = true;
            } else {
                this.wongSize = false;
                this.setValues(values);
            }
        }

        private void setValues(Object[] values) {
            this.array = new Object[TupleInCalc.this.size];
            this.hashCode = 37;
            for (int i = 0; i < TupleInCalc.this.size; ++i) {
                Object value = values[i];
                if (value instanceof Number) {
                    this.array[i] = AlgoUtil.toBigDecimal(value);
                    this.hashCode += 7 * ((BigDecimal)this.array[i]).intValue();
                    continue;
                }
                this.array[i] = value;
                this.hashCode += 7 * value.hashCode();
            }
        }

        public boolean equals(Object x) {
            return !this.wongSize && x != null && this.equalInKey((InKey)x);
        }

        private boolean equalInKey(InKey inKey) {
            if (inKey.wongSize) {
                return false;
            }
            for (int i = 0; i < TupleInCalc.this.size; ++i) {
                if (AlgoUtil.equal(this.array[i], inKey.array[i])) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

