/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.tree.calc;

import java.math.BigDecimal;
import kd.bos.algo.RowFeature;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.calc.Calc;

public final class UnaryMinusCalc
extends Calc {
    private Calc child;

    public UnaryMinusCalc(Expr expr, Calc child) {
        super(expr);
        this.child = child;
    }

    @Override
    public Object executeImpl(RowFeature row1, RowFeature row2) {
        Object value = this.child.execute(row1, row2);
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return -((Integer)value).intValue();
        }
        if (value instanceof Long) {
            return -((Long)value).longValue();
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).negate();
        }
        if (value instanceof Double) {
            return -((Double)value).doubleValue();
        }
        throw this.wrapException("Number value required, but found " + value + " of " + value.getClass().getName());
    }
}

