/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.storage;

import java.io.IOException;
import java.util.List;
import kd.bos.algo.storage.CacheReader;
import kd.bos.algo.util.ZipUtil;

public class ZipReader
implements CacheReader {
    private CacheReader inner;

    public ZipReader(CacheReader inner) {
        this.inner = inner;
    }

    @Override
    public byte[] getMeta(String key) throws IOException {
        return this.inner.get(key);
    }

    @Override
    public byte[] get(String key) throws IOException {
        byte[] bytes = this.inner.get(key);
        bytes = ZipUtil.unZip(bytes);
        return bytes;
    }

    @Override
    public List<byte[]> get(String[] keys) throws IOException {
        List<byte[]> list = this.inner.get(keys);
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, ZipUtil.unZip(list.get(i)));
        }
        return list;
    }

    public static CacheReader WrapToZIPReader(CacheReader reader, String compressor) {
        if ("zip".equals(compressor)) {
            return new ZipReader(reader);
        }
        return reader;
    }
}

