/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.storage.tempfile;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.algo.AlgoException;
import kd.bos.algo.dataset.cache.DataSetCacheSpiFactory;
import kd.bos.algo.dataset.cache.fileserver.FileServerTempFileMetaImpl;
import kd.bos.algo.storage.CacheReader;
import kd.bos.algo.storage.CacheStorage;
import kd.bos.algo.storage.CacheWriter;
import kd.bos.algo.storage.TempFileWriter;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;

public class FileServerTempFileStorage
implements CacheStorage {
    @Override
    public String getName() {
        return "fileserver-tempfile";
    }

    @Override
    public CacheWriter create(String id, long timeout) {
        return new FileServerTempFileWriter(id, (int)timeout);
    }

    @Override
    public CacheReader open(String id) {
        return new FileServerTempFileReader();
    }

    @Override
    public boolean delete(String id) {
        String metaUrl;
        FileServerTempFileMetaImpl meta = (FileServerTempFileMetaImpl)DataSetCacheSpiFactory.getSpi().getMeta(id);
        Map<String, String> pageUrls = meta.getPageUrls();
        TempFileCache tempFileCache = null;
        if (!pageUrls.isEmpty()) {
            tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            for (String url : pageUrls.values()) {
                tempFileCache.remove(url);
            }
        }
        if ((metaUrl = meta.getMetaUrl()) != null && metaUrl.trim().length() > 0) {
            if (tempFileCache == null) {
                tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            }
            tempFileCache.remove(metaUrl);
        }
        return true;
    }

    private static class FileServerTempFileReader
    implements CacheReader {
        private TempFileCache tempFileCache;
        private byte[] emptyBytes = new byte[0];

        private FileServerTempFileReader() {
            this.tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        }

        @Override
        public byte[] get(String url) throws IOException {
            byte[] returnByte;
            InputStream inputStream = null;
            ByteArrayOutputStream bos = null;
            try {
                int length;
                if (url == null || url.length() == 0) {
                    byte[] byArray = this.emptyBytes;
                    return byArray;
                }
                inputStream = this.tempFileCache.getInputStream(url);
                byte[] byteArray = new byte[1024];
                bos = new ByteArrayOutputStream();
                while ((length = inputStream.read(byteArray)) != -1) {
                    if (length != 1024 && length > 0) {
                        bos.write(byteArray, 0, length);
                        byteArray = new byte[1024];
                        continue;
                    }
                    bos.write(byteArray);
                    byteArray = new byte[1024];
                }
                returnByte = bos.toByteArray();
            }
            catch (Throwable e) {
                throw new AlgoException("read file error:", e);
            }
            finally {
                if (bos != null) {
                    bos.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            return returnByte;
        }

        @Override
        public List<byte[]> get(String[] urls) throws IOException {
            ArrayList<byte[]> values = new ArrayList<byte[]>(urls.length);
            for (int i = 0; i < urls.length; ++i) {
                values.add(this.get(urls[i]));
            }
            return values;
        }
    }

    private static class FileServerTempFileWriter
    implements TempFileWriter {
        private String cacheId;
        private int timeOut;
        private TempFileCache tempFileCache;
        private boolean isHasFlushed;
        private Map<String, String> urlMap = new ConcurrentHashMap<String, String>(64);

        public FileServerTempFileWriter(String cacheId, int timeOut) {
            this.cacheId = cacheId;
            this.timeOut = timeOut / 1000;
            this.tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        }

        @Override
        public String put(String key, byte[] value) {
            String fileName = this.cacheId + "###" + key + ".algo.cache";
            String url = this.tempFileCache.saveAsUrl("/algo/" + fileName, value, this.timeOut);
            this.urlMap.put(fileName, url);
            return url;
        }

        @Override
        public void flush() throws IOException {
            this.isHasFlushed = true;
            this.urlMap.clear();
        }

        @Override
        public boolean hasFlushed() {
            return this.isHasFlushed;
        }

        @Override
        public Map<String, String> getUrls() {
            return this.urlMap;
        }
    }
}

