/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.util;

import java.math.BigDecimal;
import java.util.Collection;
import kd.bos.algo.AlgoException;

public final class AlgoUtil {
    public static <T> void addArray(Collection<T> col, T[] array) {
        for (T t : array) {
            col.add(t);
        }
    }

    public static int compareNumber(Number n1, Number n2) {
        if (n1 == null && n2 == null) {
            return 0;
        }
        if (n1 == null) {
            return -1;
        }
        if (n2 == null) {
            return 1;
        }
        if (n1.getClass() == n2.getClass()) {
            return ((Comparable)((Object)n1)).compareTo(n2);
        }
        return AlgoUtil.compareNumber0(n1, n2);
    }

    private static final int compareNumber0(Number n1, Number n2) {
        if (n1 instanceof BigDecimal || n2 instanceof BigDecimal) {
            return AlgoUtil.toBigDecimal(n1).compareTo(AlgoUtil.toBigDecimal(n2));
        }
        if (n1 instanceof Double || n2 instanceof Double || n1 instanceof Float || n2 instanceof Float) {
            return AlgoUtil.toBigDecimal(n1).compareTo(AlgoUtil.toBigDecimal(n2));
        }
        if (n1 instanceof Long || n2 instanceof Long) {
            return Long.compare(n1.longValue(), n2.longValue());
        }
        if (n1 instanceof Integer || n2 instanceof Integer) {
            return Integer.compare(n1.intValue(), n2.intValue());
        }
        if (n1 instanceof Short || n2 instanceof Short) {
            return Short.compare(n1.shortValue(), n2.shortValue());
        }
        if (n1 instanceof Byte || n2 instanceof Byte) {
            return Byte.compare(n1.byteValue(), n2.byteValue());
        }
        throw new AlgoException("Unsupported Number class:" + n1.getClass() + "," + n2.getClass());
    }

    public static final BigDecimal toBigDecimal(Object v) {
        if (v == null) {
            return null;
        }
        if (v instanceof BigDecimal) {
            return (BigDecimal)v;
        }
        return new BigDecimal(v.toString());
    }

    public static final BigDecimal toBigDecimal(Number n) {
        if (n instanceof BigDecimal) {
            return (BigDecimal)n;
        }
        if (n instanceof Long) {
            return BigDecimal.valueOf((Long)n);
        }
        if (n instanceof Integer) {
            return BigDecimal.valueOf(((Integer)n).intValue());
        }
        if (n instanceof Double) {
            return BigDecimal.valueOf((Double)n);
        }
        return new BigDecimal(String.valueOf(n));
    }

    public static int compareValue(Object a, Object b) {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        if (a instanceof Number && b instanceof Number) {
            return AlgoUtil.compareNumber((Number)a, (Number)b);
        }
        if (a instanceof Comparable && b instanceof Comparable) {
            return ((Comparable)a).compareTo((Comparable)b);
        }
        throw new AlgoException("Values not comparable:" + a + " and " + b);
    }

    public static boolean equal(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        if (a instanceof Number && b instanceof Number) {
            return AlgoUtil.compareNumber((Number)a, (Number)b) == 0;
        }
        if (a instanceof Comparable && b instanceof Comparable) {
            return ((Comparable)a).compareTo((Comparable)b) == 0;
        }
        return a.equals(b);
    }

    public static void discard(Object o) {
    }
}

