/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.util;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.algo.util.AlgoUtil;

public class DataSetComparator {
    public static void compare(DataSet ds1, DataSet ds2, boolean orderFirst) {
        RowMeta rowMeta1 = ds1.getRowMeta();
        RowMeta rowMeta2 = ds2.getRowMeta();
        Preconditions.checkArgument((rowMeta1.getFieldCount() == rowMeta2.getFieldCount() ? 1 : 0) != 0);
        int length = rowMeta1.getFieldCount();
        for (int i = 0; i < rowMeta1.getFieldCount(); ++i) {
            Preconditions.checkArgument((boolean)rowMeta1.getField(i).equals(rowMeta2.getField(i)));
        }
        if (orderFirst) {
            String[] orderFields = new String[rowMeta1.getFieldCount()];
            for (int i = 0; i < orderFields.length; ++i) {
                orderFields[i] = rowMeta1.getFieldAlias(i);
            }
            ds1 = ds1.orderBy(orderFields);
            ds2 = ds2.orderBy(orderFields);
        }
        while (ds1.hasNext()) {
            if (!ds2.hasNext()) {
                throw new AlgoException("ds1 has more rows than ds2.");
            }
            Row row1 = ds1.next();
            Row row2 = ds2.next();
            for (int i = 0; i < length; ++i) {
                Preconditions.checkArgument((AlgoUtil.compareValue(row1.get(i), row2.get(i)) == 0 ? 1 : 0) != 0, (Object)("Row data not equals, row1: " + Arrays.toString(((AbstractRow)row1).values()) + ",row2: " + Arrays.toString(((AbstractRow)row2).values())));
            }
        }
        if (ds2.hasNext()) {
            throw new AlgoException("ds2 has more rows than ds1.");
        }
    }
}

