/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import kd.bos.algo.AlgoException;

public class ZipUtil {
    public static byte[] zip(byte[] data) {
        byte[] b = null;
        ZipOutputStream zip = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            zip = new ZipOutputStream(bos);
            ZipEntry entry = new ZipEntry("zip");
            entry.setSize(data.length);
            zip.putNextEntry(entry);
            zip.write(data);
            zip.closeEntry();
            zip.close();
            b = bos.toByteArray();
            bos.close();
            zip = null;
        }
        catch (Exception ex) {
            throw new AlgoException(ex);
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return b;
    }

    public static byte[] unZip(byte[] data) {
        byte[] b = null;
        ZipInputStream zip = null;
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            zip = new ZipInputStream(bis);
            while (zip.getNextEntry() != null) {
                byte[] buf = new byte[1024];
                int num = -1;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                while ((num = zip.read(buf, 0, buf.length)) != -1) {
                    baos.write(buf, 0, num);
                }
                b = baos.toByteArray();
                baos.flush();
                baos.close();
            }
            zip.close();
            bis.close();
            zip = null;
        }
        catch (Exception ex) {
            throw new AlgoException(ex);
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return b;
    }
}

