/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.util.columnbased.impl;

import java.util.ArrayList;
import kd.bos.algo.util.columnbased.ColumnBasedGrid;
import kd.bos.algo.util.columnbased.impl.ColumnBasedGridImpl;

public class PagedGrid
implements ColumnBasedGrid {
    private static final long serialVersionUID = -8258012211539241512L;
    private int columnCount;
    private int pageSize;
    private int rowCount;
    private ArrayList<ColumnBasedGridImpl> pageList = new ArrayList();

    public PagedGrid(int columnCount, int pageSize) {
        this.columnCount = columnCount;
        this.pageSize = pageSize;
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public Object getCell(int columnIndex, int rowIndex) {
        int pageIndex = rowIndex / this.pageSize;
        int pageOffset = rowIndex % this.pageSize;
        return this.pageList.get(pageIndex).getCell(columnIndex, pageOffset);
    }

    @Override
    public void setCell(int columnIndex, int rowIndex, Object value) {
        int pageIndex = rowIndex / this.pageSize;
        int pageOffset = rowIndex % this.pageSize;
        this.pageList.get(pageIndex).setCell(columnIndex, pageOffset, value);
    }

    @Override
    public void appendRow(Object[] objects) {
        ColumnBasedGridImpl grid;
        int pageOffset = this.rowCount % this.pageSize;
        if (pageOffset == 0) {
            grid = new ColumnBasedGridImpl(this.columnCount);
            this.pageList.add(grid);
        } else {
            grid = this.pageList.get(this.rowCount / this.pageSize);
        }
        grid.appendRow(objects);
        ++this.rowCount;
    }

    @Override
    public void toRowArray(int rowIndex, Object[] objects) {
        int pageIndex = rowIndex / this.pageSize;
        int pageOffset = rowIndex % this.pageSize;
        this.pageList.get(pageIndex).toRowArray(pageOffset, objects);
    }
}

