/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.util.columnbased.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import kd.bos.algo.util.columnbased.impl.OnlyKeyMap;
import kd.bos.algo.util.columnbased.impl.Vector;

public class ShareObjectVector
implements Vector,
Serializable {
    private static final long serialVersionUID = -5820267740365678694L;
    private transient ArrayList<Object> values = new ArrayList();
    private transient OnlyKeyMap<Object> map = new OnlyKeyMap();
    private int cardinality;

    public ShareObjectVector() {
    }

    public ShareObjectVector(Object[] rows) {
        for (int i = 0; i < rows.length; ++i) {
            this.append(rows[i]);
        }
    }

    public ShareObjectVector(Iterator<Object> iter) {
        while (iter.hasNext()) {
            this.append(iter.next());
        }
    }

    public ShareObjectVector(Collection<Object> collection) {
        Iterator<Object> iter = collection.iterator();
        while (iter.hasNext()) {
            this.append(iter.next());
        }
    }

    @Override
    public int getSize() {
        return this.values.size();
    }

    @Override
    public Object get(int row) {
        return this.values.get(row);
    }

    @Override
    public void append(Object o) {
        this.ensureMap();
        this.map.putKey(o);
        this.values.add(o);
    }

    @Override
    public void set(int index, Object o) {
        this.ensureMap();
        if (this.map.containsKey(o)) {
            this.values.set(index, this.map.getKey(o));
        } else {
            this.map.putKey(o);
            this.values.set(index, o);
        }
    }

    @Override
    public int getCardinality() {
        if (this.map != null) {
            this.cardinality = this.map.size;
        }
        return this.cardinality;
    }

    @Override
    public double getFactor() {
        if (this.map != null) {
            this.cardinality = this.map.size;
        }
        return 1.0 * (double)this.cardinality / (double)this.values.size();
    }

    @Override
    public void finishAppend() {
        if (this.map != null) {
            this.cardinality = this.map.size;
            this.map = null;
        }
    }

    public void ensureMap() {
        if (this.map == null) {
            this.map = new OnlyKeyMap(this.cardinality + 1);
            Iterator<Object> iter = this.values.iterator();
            while (iter.hasNext()) {
                this.map.putKey(iter.next());
            }
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.finishAppend();
        int size = this.values.size();
        s.writeInt(size);
        s.writeInt(this.cardinality);
        for (int i = 0; i < size; ++i) {
            s.writeObject(this.values.get(i));
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        int size = s.readInt();
        this.cardinality = s.readInt();
        this.values = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            Object o = s.readObject();
            this.values.add(o);
        }
    }

    @Override
    public Iterator<Object> iterator() {
        return new MyIterator();
    }

    private class MyIterator
    implements Iterator<Object> {
        int pos = 0;

        private MyIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pos < ShareObjectVector.this.values.size();
        }

        @Override
        public Object next() {
            Object t = ShareObjectVector.this.values.get(this.pos);
            ++this.pos;
            return t;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

