/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.util.io.disk;

import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.util.io.disk.AsynchronousBlockWriterWithCallback;
import kd.bos.algo.util.io.disk.BlockChannelWriter;
import kd.bos.algo.util.io.disk.FileIOChannel;
import kd.bos.algo.util.io.disk.QueuingCallback;
import kd.bos.algo.util.io.disk.RequestQueue;
import kd.bos.algo.util.io.disk.WriteRequest;
import kd.bos.algo.util.memory.MemorySegment;

public class AsynchronousBlockWriter
extends AsynchronousBlockWriterWithCallback
implements BlockChannelWriter<MemorySegment> {
    private final LinkedBlockingQueue<MemorySegment> returnSegments;

    protected AsynchronousBlockWriter(FileIOChannel.ID channelID, RequestQueue<WriteRequest> requestQueue, LinkedBlockingQueue<MemorySegment> returnSegments) throws IOException {
        super(channelID, requestQueue, new QueuingCallback<MemorySegment>(returnSegments));
        this.returnSegments = returnSegments;
    }

    @Override
    public MemorySegment getNextReturnedBlock() throws IOException {
        try {
            while (true) {
                MemorySegment next;
                if ((next = this.returnSegments.poll(1000L, TimeUnit.MILLISECONDS)) != null) {
                    return next;
                }
                if (this.closed) {
                    throw new IOException("The writer has been closed.");
                }
                this.checkErroneous();
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Writer was interrupted while waiting for the next returning segment.");
        }
    }

    @Override
    public LinkedBlockingQueue<MemorySegment> getReturnQueue() {
        return this.returnSegments;
    }
}

