/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.util.io.disk;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.algo.util.ShutdownHookUtil;
import kd.bos.algo.util.io.IOUtils;
import kd.bos.algo.util.io.disk.FileChannelManager;
import kd.bos.algo.util.io.disk.FileIOChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileChannelManagerImpl
implements FileChannelManager {
    private static final Logger LOG = LoggerFactory.getLogger(FileChannelManagerImpl.class);
    private final File[] paths;
    private final Random random;
    private volatile int nextPath;
    private final String prefix;
    private final AtomicBoolean isShutdown = new AtomicBoolean();
    private final Thread shutdownHook;

    public FileChannelManagerImpl(String[] tempDirs, String prefix) {
        Preconditions.checkNotNull((Object)tempDirs, (Object)"The temporary directories must not be null.");
        Preconditions.checkArgument((tempDirs.length > 0 ? 1 : 0) != 0, (Object)"The temporary directories must not be empty.");
        this.random = new Random();
        this.nextPath = 0;
        this.prefix = prefix;
        this.shutdownHook = ShutdownHookUtil.addShutdownHook(this, String.format("%s-%s", this.getClass().getSimpleName(), prefix), LOG);
        this.paths = FileChannelManagerImpl.createFiles(tempDirs, prefix);
    }

    private static File[] createFiles(String[] tempDirs, String prefix) {
        File[] files = new File[tempDirs.length];
        for (int i = 0; i < tempDirs.length; ++i) {
            File baseDir = new File(tempDirs[i]);
            String subfolder = String.format("%s-%s", prefix, UUID.randomUUID().toString());
            File storageDir = new File(baseDir, subfolder);
            if (!storageDir.exists() && !storageDir.mkdirs()) {
                throw new RuntimeException("Could not create storage directory for FileChannelManager: " + storageDir.getAbsolutePath());
            }
            files[i] = storageDir;
            LOG.info("FileChannelManager uses directory {} for spill files.", (Object)storageDir.getAbsolutePath());
        }
        return files;
    }

    @Override
    public FileIOChannel.ID createChannel() {
        Preconditions.checkState((!this.isShutdown.get() ? 1 : 0) != 0, (Object)"File channel manager has shutdown.");
        int num = this.getNextPathNum();
        return new FileIOChannel.ID(this.paths[num], num, this.random);
    }

    @Override
    public FileIOChannel.Enumerator createChannelEnumerator() {
        Preconditions.checkState((!this.isShutdown.get() ? 1 : 0) != 0, (Object)"File channel manager has shutdown.");
        return new FileIOChannel.Enumerator(this.paths, this.random);
    }

    @Override
    public File[] getPaths() {
        Preconditions.checkState((!this.isShutdown.get() ? 1 : 0) != 0, (Object)"File channel manager has shutdown.");
        return Arrays.copyOf(this.paths, this.paths.length);
    }

    @Override
    public void close() throws Exception {
        if (!this.isShutdown.compareAndSet(false, true)) {
            return;
        }
        IOUtils.closeAll(Arrays.stream(this.paths).filter(File::exists).map(FileChannelManagerImpl::getFileCloser).collect(Collectors.toList()));
        ShutdownHookUtil.removeShutdownHook(this.shutdownHook, String.format("%s-%s", this.getClass().getSimpleName(), this.prefix), LOG);
    }

    private static AutoCloseable getFileCloser(File path) {
        return () -> {
            try {
                FileChannelManagerImpl.deleteFileOrDirectory(path);
                LOG.info("FileChannelManager removed spill file directory {}", (Object)path.getPath());
            }
            catch (IOException e) {
                String errorMessage = String.format("FileChannelManager failed to properly clean up temp file directory: %s", path);
                throw new IOException(errorMessage, e);
            }
        };
    }

    private static String getFilePath(File path) {
        return path.getAbsolutePath();
    }

    private int getNextPathNum() {
        int next = this.nextPath;
        int newNext = next + 1;
        this.nextPath = newNext >= this.paths.length ? 0 : newNext;
        return next;
    }

    private static void deleteFileOrDirectory(File file) throws IOException {
        if (file.isDirectory()) {
            FileChannelManagerImpl.deleteDirectoryInternal(file);
        } else {
            Files.deleteIfExists(file.toPath());
        }
    }

    private static void deleteDirectoryInternal(File directory) throws IOException {
        if (directory.isDirectory()) {
            try {
                FileChannelManagerImpl.cleanDirectoryInternal(directory);
            }
            catch (FileNotFoundException arg1) {
                return;
            }
            Files.deleteIfExists(directory.toPath());
        } else if (directory.exists()) {
            throw new IOException(directory + " is not a directory");
        }
    }

    private static void cleanDirectoryInternal(File directory) throws IOException {
        if (!Files.isSymbolicLink(directory.toPath())) {
            if (directory.isDirectory()) {
                File[] files = directory.listFiles();
                if (files == null) {
                    if (directory.exists()) {
                        throw new IOException("Failed to list contents of " + directory);
                    }
                    throw new FileNotFoundException(directory.toString());
                }
                File[] arg1 = files;
                int arg2 = files.length;
                for (int arg3 = 0; arg3 < arg2; ++arg3) {
                    File file = arg1[arg3];
                    if (file == null) continue;
                    FileChannelManagerImpl.deleteFileOrDirectory(file);
                }
            } else {
                if (directory.exists()) {
                    throw new IOException(directory + " is not a directory but a regular file");
                }
                throw new FileNotFoundException(directory.toString());
            }
        }
    }
}

