/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.util.io.disk;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.algo.util.StringUtils;

public interface FileIOChannel {
    public ID getChannelID();

    public long getSize() throws IOException;

    public boolean isClosed();

    public void close() throws IOException;

    public void deleteChannel();

    public FileChannel getNioFileChannel();

    public void closeAndDelete() throws IOException;

    public static final class Enumerator {
        private static AtomicInteger globalCounter = new AtomicInteger();
        private final File[] paths;
        private final String namePrefix;
        private int localCounter;

        public Enumerator(File[] basePaths, Random random) {
            this.paths = basePaths;
            this.namePrefix = ID.randomString(random);
            this.localCounter = 0;
        }

        public ID next() {
            int threadNum = globalCounter.getAndIncrement() % this.paths.length;
            String filename = String.format("%s.%06d.channel", this.namePrefix, this.localCounter++);
            return new ID(new File(this.paths[threadNum], filename), threadNum);
        }
    }

    public static class ID {
        private static final int RANDOM_BYTES_LENGTH = 16;
        private final File path;
        private final int threadNum;

        private ID(File path, int threadNum) {
            this.path = path;
            this.threadNum = threadNum;
        }

        public ID(File basePath, int threadNum, Random random) {
            this.path = new File(basePath, ID.randomString(random) + ".channel");
            this.threadNum = threadNum;
        }

        public String getPath() {
            return this.path.getAbsolutePath();
        }

        public File getPathFile() {
            return this.path;
        }

        int getThreadNum() {
            return this.threadNum;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ID) {
                ID other = (ID)obj;
                return this.path.equals(other.path) && this.threadNum == other.threadNum;
            }
            return false;
        }

        public int hashCode() {
            return this.path.hashCode();
        }

        public String toString() {
            return this.path.getAbsolutePath();
        }

        private static String randomString(Random random) {
            byte[] bytes = new byte[16];
            random.nextBytes(bytes);
            return StringUtils.byteToHexString(bytes);
        }
    }
}

