/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.util.io.disk;

import java.io.EOFException;
import java.util.ArrayList;
import kd.bos.algo.AlgoException;
import kd.bos.algo.util.ObjectRef;
import kd.bos.algo.util.io.ExceptionUtils;
import kd.bos.algo.util.memory.AbstractPagedInputView;
import kd.bos.algo.util.memory.MemorySegment;
import kd.bos.algo.util.memory.SeekableDataInputView;

public class RandomAccessInputView
extends AbstractPagedInputView
implements SeekableDataInputView {
    private final ArrayList<MemorySegment> segments;
    private int currentSegmentIndex;
    private final int segmentSizeBits;
    private final int segmentSizeMask;
    private final int segmentSize;
    private final int limitInLastSegment;
    private final ObjectRef<Exception> closedRef;

    public RandomAccessInputView(ArrayList<MemorySegment> segments, int segmentSize, int limitInLastSegment, ObjectRef<Exception> closedRef) {
        super(segments.get(0), segments.size() > 1 ? segmentSize : limitInLastSegment, 0);
        this.segments = segments;
        this.currentSegmentIndex = 0;
        this.segmentSize = segmentSize;
        this.segmentSizeBits = RandomAccessInputView.log2strict(segmentSize);
        this.segmentSizeMask = segmentSize - 1;
        this.limitInLastSegment = limitInLastSegment;
        this.closedRef = closedRef;
    }

    @Override
    public void setReadPosition(long position) {
        int bufferNum = (int)(position >>> this.segmentSizeBits);
        int offset = (int)(position & (long)this.segmentSizeMask);
        this.currentSegmentIndex = bufferNum;
        this.seekInput(this.segments.get(bufferNum), offset, bufferNum < this.segments.size() - 1 ? this.segmentSize : this.limitInLastSegment);
    }

    public long getReadPosition() {
        return ((long)this.currentSegmentIndex << this.segmentSizeBits) + (long)this.getCurrentPositionInSegment();
    }

    @Override
    protected MemorySegment nextSegment(MemorySegment current) throws EOFException {
        if (this.closedRef != null && this.closedRef.get() != null) {
            throw new AlgoException("View has been closed, currentSegmentIndex:" + (this.currentSegmentIndex - 1) + ",segmentSize:" + this.segments.size() + ", close stack is:" + ExceptionUtils.stringifyException(this.closedRef.get()));
        }
        if (++this.currentSegmentIndex < this.segments.size()) {
            return this.segments.get(this.currentSegmentIndex);
        }
        throw new EOFException("currentSegmentIndex:" + (this.currentSegmentIndex - 1) + ",segmentSize:" + this.segments.size());
    }

    @Override
    protected int getLimitForSegment(MemorySegment segment) {
        return this.currentSegmentIndex == this.segments.size() - 1 ? this.limitInLastSegment : this.segmentSize;
    }

    private static int log2strict(int value) throws ArithmeticException, IllegalArgumentException {
        if (value == 0) {
            throw new ArithmeticException("Logarithm of zero is undefined.");
        }
        if ((value & value - 1) != 0) {
            throw new IllegalArgumentException("The given value " + value + " is not a power of two.");
        }
        return 31 - Integer.numberOfLeadingZeros(value);
    }
}

