/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.util.trie;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TrieTree
implements Serializable {
    private static final long serialVersionUID = -3972877318876503523L;
    private TrieNode root = new TrieNode();
    private long size;

    public TrieTree() {
        this.root.wordEnd = false;
    }

    public void insert(String word) {
        TrieNode node = this.root;
        for (int i = 0; i < word.length(); ++i) {
            Character c = Character.valueOf(word.charAt(i));
            if (!node.children.containsKey(c)) {
                node.children.put(c, new TrieNode());
            }
            node = node.children.get(c);
        }
        node.wordEnd = true;
        ++node.wordCount;
        if (node.wordCount <= 1L) {
            ++this.size;
        }
    }

    public boolean search(String word) {
        TrieNode node = this.root;
        for (int i = 0; i < word.length(); ++i) {
            Character c = Character.valueOf(word.charAt(i));
            if (!node.children.containsKey(c)) {
                return false;
            }
            node = node.children.get(c);
        }
        return node.wordEnd;
    }

    public void join(TrieTree tree) {
        TrieNode root = tree.root;
        Map<Character, TrieNode> children = root.children;
        if (children == null || children.size() == 0) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Character, TrieNode> entry : children.entrySet()) {
        }
    }

    private String join(Iterator<Map.Entry<Character, TrieNode>> iterator) {
        return null;
    }

    public long wordCount(String word) {
        TrieNode node = this.root;
        for (int i = 0; i < word.length(); ++i) {
            Character c = Character.valueOf(word.charAt(i));
            if (!node.children.containsKey(c)) {
                return 0L;
            }
            node = node.children.get(c);
        }
        return node.wordCount;
    }

    public long size() {
        return this.size;
    }

    public boolean startsWithWordCount(String prefix) {
        TrieNode node = this.root;
        for (int i = 0; i < prefix.length(); ++i) {
            Character c = Character.valueOf(prefix.charAt(i));
            if (!node.children.containsKey(c)) {
                return false;
            }
            node = node.children.get(c);
        }
        return true;
    }

    private static class TrieNode
    implements Serializable {
        private static final long serialVersionUID = -8912117368545194148L;
        Map<Character, TrieNode> children = new HashMap<Character, TrieNode>();
        boolean wordEnd = false;
        long wordCount = 0L;
    }
}

